/*
 * Decompiled with CFR 0.152.
 */
package com.palm.novacom.internal;

import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import com.palm.novacom.internal.NovacomSocketStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class NovacomDevice
implements INovacomDevice {
    private static final String ENCODING = "US-ASCII";
    private final String host;
    private String hashNP;
    private String hashNPS;
    NovaDeviceInfo devInfo;

    NovacomDevice(String host, NovaDeviceInfo devInfo) {
        this.host = host;
        this.devInfo = devInfo;
    }

    @Override
    public void close() {
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.devInfo.getPort();
    }

    @Override
    public NovaDeviceInfo getDeviceInfo() {
        return this.devInfo;
    }

    private String socketReadLine(Socket socket) throws IOException, NovacomException {
        int length;
        InputStream input = socket.getInputStream();
        byte[] reply = new byte[256];
        for (length = 0; length < reply.length; ++length) {
            int c = input.read();
            if (c == -1) {
                throw new NovacomException(-2, "No data to read from socket");
            }
            reply[length] = (byte)c;
            if (c != 10) continue;
        }
        return new String(reply, 0, length);
    }

    private boolean handleReply(Socket socket) throws IOException, NovacomException {
        String strReply = this.socketReadLine(socket);
        if (strReply.startsWith("ok")) {
            return true;
        }
        if (strReply.startsWith("err")) {
            return false;
        }
        if (strReply.startsWith("req:auth")) {
            throw new NovacomException(-13, "Access denied");
        }
        throw new NovacomException(-71, "Unsupported reply: " + strReply);
    }

    private String prepareCommand(String verb, String scheme, String[] args) {
        StringBuilder cmd = new StringBuilder(verb);
        cmd.append(" ");
        cmd.append(scheme);
        for (int i = 0; args != null && i < args.length; ++i) {
            cmd.append(" ");
            cmd.append(args[i]);
        }
        cmd.append("\n");
        return cmd.toString();
    }

    private Socket sendCommand(int port, String cmd) throws NovacomException, IOException {
        Socket socket = null;
        try {
            socket = new Socket(this.host, port);
            OutputStream output = socket.getOutputStream();
            output.write(cmd.getBytes(ENCODING));
        }
        catch (IOException e) {
            if (socket != null) {
                socket.close();
                socket = null;
            }
            if (!this.isConnected()) {
                NovacomException e2 = new NovacomException(-107, "Device has been disconnected. Command: " + new String(cmd.replaceAll("\n", "")));
                e2.setStackTrace(e.getStackTrace());
                throw e2;
            }
            throw e;
        }
        return socket;
    }

    INovacomStream issueCommand(String verb, String scheme, String[] args) throws NovacomException, IOException {
        String cmd = this.prepareCommand(verb, scheme, args);
        Socket socket = this.sendCommand(this.devInfo.getPort(), cmd);
        try {
            boolean result = this.handleReply(socket);
            if (!result) {
                throw new NovacomException(-74, "Command processing error...");
            }
        }
        catch (NovacomException e) {
            socket.close();
            NovacomException e2 = new NovacomException(e.getErrorCode(), "Command: " + new String(cmd.toString().replaceAll("\n", "")) + ". Reply:" + new String(e.getMessage().replaceAll("\n", "")));
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
        return new NovacomSocketStream(socket, scheme);
    }

    private boolean issueCtrlCommand(String verb, String scheme, String[] args) throws NovacomException, IOException {
        boolean result;
        if (null == this.devInfo.getSessionId()) {
            return false;
        }
        String cmd = this.prepareCommand(verb, scheme, args);
        Socket socket = this.sendCommand(this.devInfo.getCtrlPort(), cmd);
        try {
            result = this.handleReply(socket);
        }
        catch (NovacomException e) {
            socket.close();
            NovacomException e2 = new NovacomException(e.getErrorCode(), "Command: " + new String(cmd.toString().replaceAll("\n", "")) + ". Reply:" + new String(e.getMessage().replaceAll("\n", "")));
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
        return result;
    }

    @Override
    public INovacomStream getFile(String path) throws NovacomException, IOException {
        return this.issueCommand("get", "file://" + path, null);
    }

    @Override
    public INovacomStream putFile(String path) throws NovacomException, IOException {
        return this.issueCommand("put", "file://" + path, null);
    }

    @Override
    public boolean checkFile(String path) {
        try {
            this.getFile(path);
            return true;
        }
        catch (NovacomException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public INovacomStream openTerminal(int tty) throws NovacomException, IOException {
        return this.issueCommand("open", "tty://" + tty, null);
    }

    @Override
    public INovacomStream runProgram(String path, String[] args) throws NovacomException, IOException {
        return this.issueCommand("run", "file://" + path, args);
    }

    @Override
    public void runProgramAndWait(String path, String[] args) throws NovacomException, IOException {
        INovacomStream stream = this.runProgram(path, args);
        stream.waitForReturnCode();
        stream.close();
    }

    @Override
    public INovacomStream runScript(String script, String path) throws NovacomException, IOException {
        INovacomStream stream = this.putFile(path);
        stream.write(script.getBytes(ENCODING));
        stream.closeInput();
        stream.closeOutput();
        stream.waitForReturnCode();
        stream.close();
        return this.runProgram("/bin/sh", new String[]{"-c " + path});
    }

    @Override
    public INovacomStream putInMemory(long address, boolean boot) throws NovacomException, IOException {
        return this.putInMemory(Long.toString(address, 16), boot);
    }

    @Override
    public INovacomStream putInMemory(String address, boolean boot) throws NovacomException, IOException {
        String cmd = "put";
        if (boot) {
            cmd = "boot";
        }
        return this.issueCommand(cmd, "mem://" + address, null);
    }

    @Override
    public INovacomStream connectDevicePort(int port) throws NovacomException, IOException {
        return this.issueCommand("connect", "tcp-port://" + port, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Novacom.DeviceState getState() throws IOException {
        INovacomStream stream = null;
        try {
            stream = this.getFile("/proc/mounts");
            try {
                stream.close();
            }
            catch (Exception exc) {
                // empty catch block
            }
            stream = this.getFile("/proc/cmdline");
            String cmdline = stream.readLine();
            if (cmdline.indexOf("ram0") > 0) {
                Novacom.DeviceState deviceState = Novacom.DeviceState.INSTALLER;
                return deviceState;
            }
            Novacom.DeviceState deviceState = Novacom.DeviceState.OS;
            return deviceState;
        }
        catch (NovacomException e) {
            if (-13 == e.getErrorCode()) {
                Novacom.DeviceState deviceState = Novacom.DeviceState.UNKNOWN;
                return deviceState;
            }
            Novacom.DeviceState deviceState = Novacom.DeviceState.BOOTLOADER;
            return deviceState;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exc) {}
            }
        }
    }

    @Override
    public void killConnection() throws IOException, NovacomException {
        Novacom.DeviceState deviceState = this.getState();
        if (deviceState == Novacom.DeviceState.OS || deviceState == Novacom.DeviceState.INSTALLER) {
            try {
                String[] args = new String[]{"-15", "novacomd"};
                this.runProgram("/usr/bin/killall", args);
            }
            catch (NovacomException e) {
                if (e.getErrorCode() != -2) {
                    throw e;
                }
                return;
            }
        } else {
            throw new NovacomException(-1, "Cannot kill connection in anything but OS mode.");
        }
    }

    @Override
    public void waitForDeviceToAppear() throws IOException, NovacomException {
        this.waitForDeviceToAppear(180000L);
    }

    @Override
    public void waitForDeviceToAppear(long timeout) throws IOException, NovacomException {
        INovacomDevice newdev = null;
        INovacomController controller = Novacom.getController(this.host, 6968);
        long timeToTimeoutOn = System.currentTimeMillis() + timeout;
        do {
            NovaDeviceInfo[] devices = controller.getDeviceList();
            for (int i = 0; i < devices.length; ++i) {
                if (devices[i].getUIDString().compareTo(this.devInfo.getUIDString()) != 0 || devices[i].getPort() == this.devInfo.getPort()) continue;
                newdev = controller.connectToDevice(devices[i]);
                break;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (timeToTimeoutOn >= System.currentTimeMillis()) continue;
            throw new NovacomException(-1, "Timeout waiting for device to appear");
        } while (newdev == null);
        this.devInfo = newdev.getDeviceInfo();
        if (null != this.devInfo.getSessionId() && null != this.hashNP) {
            this.calcHash(null, hashCalcType.HASHCALC_REUSENP);
        }
    }

    @Override
    public boolean isConnected() throws IOException, NovacomException {
        boolean devConnected = false;
        INovacomController controller = Novacom.getController(this.host, 6968);
        NovaDeviceInfo[] devices = controller.getDeviceList();
        for (int i = 0; i < devices.length; ++i) {
            if (devices[i].getUIDString().compareTo(this.devInfo.getUIDString()) != 0 || devices[i].getPort() != this.devInfo.getPort()) continue;
            devConnected = true;
            break;
        }
        return devConnected;
    }

    void streamToFile(String hostFileName, INovacomStream deviceStream) throws IOException, NovacomException {
        int count;
        FileOutputStream fileStream = new FileOutputStream(hostFileName);
        byte[] buffer = new byte[0x100000];
        long total = 0L;
        while ((count = deviceStream.read(buffer)) != -1) {
            fileStream.write(buffer, 0, count);
            total += (long)count;
            if (count >= buffer.length) continue;
        }
        fileStream.close();
    }

    private String bytesToHexStr(byte[] hash) {
        StringBuilder hex = new StringBuilder();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (int i = 0; i < hash.length; ++i) {
            hex.append(hexChars[(hash[i] & 0xFF) / 16]);
            hex.append(hexChars[(hash[i] & 0xFF) % 16]);
        }
        return hex.toString();
    }

    private String calcHash(String devicePass, hashCalcType calcType) throws NovacomException {
        byte[] hash;
        String str;
        MessageDigest sha;
        if (hashCalcType.HASHCALC_FULLCYCLE == calcType) {
            if (null == devicePass) {
                throw new NovacomException(-22, "Empty password string...");
            }
        } else if (null == this.hashNP) {
            throw new NovacomException(-22, "Invalid call...");
        }
        if (null == this.devInfo.getSessionId()) {
            throw new NovacomException(-56, "Restricted access mode is not active...");
        }
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new NovacomException(-125, "Unable to get instance of SHA1 message digest...");
        }
        if (hashCalcType.HASHCALC_FULLCYCLE == calcType) {
            str = this.devInfo.getUIDString().toLowerCase() + devicePass;
            sha.update(str.getBytes());
            hash = sha.digest();
            this.hashNP = this.bytesToHexStr(hash);
        }
        str = this.hashNP + this.devInfo.getSessionId();
        sha.update(str.getBytes());
        hash = sha.digest();
        this.hashNPS = this.bytesToHexStr(hash);
        return this.hashNPS;
    }

    @Override
    public void devPass(String devicePass) throws NovacomException {
        this.calcHash(devicePass, hashCalcType.HASHCALC_FULLCYCLE);
    }

    @Override
    public boolean devLogin(String devicePass) throws IOException, NovacomException {
        if (null == devicePass && null == this.hashNPS) {
            return false;
        }
        if (null != devicePass) {
            this.calcHash(devicePass, hashCalcType.HASHCALC_FULLCYCLE);
        }
        return this.issueCtrlCommand("login", "dev://" + this.devInfo.getUIDString(), new String[]{this.hashNPS});
    }

    @Override
    public boolean devLogout() throws IOException, NovacomException {
        return this.issueCtrlCommand("logout", "dev://" + this.devInfo.getUIDString(), null);
    }

    @Override
    public boolean devAddToken(String devicePass) throws IOException, NovacomException {
        if (null == devicePass && null == this.hashNPS) {
            return false;
        }
        if (null != devicePass) {
            this.calcHash(devicePass, hashCalcType.HASHCALC_FULLCYCLE);
        }
        return this.issueCtrlCommand("add", "dev://" + this.devInfo.getUIDString(), new String[]{this.hashNPS});
    }

    @Override
    public boolean devRmToken(String devicePass) throws IOException, NovacomException {
        if (null == devicePass && null == this.hashNPS) {
            return false;
        }
        if (null != devicePass) {
            this.calcHash(devicePass, hashCalcType.HASHCALC_FULLCYCLE);
        }
        return this.issueCtrlCommand("remove", "dev://" + this.devInfo.getUIDString(), new String[]{this.hashNPS});
    }

    private static enum hashCalcType {
        HASHCALC_FULLCYCLE,
        HASHCALC_REUSENP;

    }
}

