/*
 * Decompiled with CFR 0.152.
 */
package com.palm.novacom;

import java.io.IOException;

public class NovaDeviceInfo {
    protected int port;
    protected byte[] uid;
    protected String uidString;
    protected String transport;
    protected String name;
    protected String ssid;
    public static final int DEFAULT_CTRL_PORT = 6971;
    protected int ctrlPort = 6971;

    public NovaDeviceInfo(String info) {
        String[] tokens = info.split("\\s");
        this.port = Integer.parseInt(tokens[0]);
        this.uid = new byte[20];
        tokens[1] = tokens[1].toUpperCase();
        assert (tokens[1].length() == 40);
        this.uidString = tokens[1];
        try {
            byte[] uidText = this.uidString.getBytes("US-ASCII");
            for (int i = 0; i < this.uid.length; ++i) {
                byte[] nibbles = new byte[2];
                for (int n = 0; n < nibbles.length; ++n) {
                    nibbles[n] = uidText[i] >= 48 && uidText[i + n] <= 57 ? (byte)(48 - uidText[i]) : (byte)(75 - uidText[i + n]);
                }
                this.uid[i] = (byte)(nibbles[0] << 4 | nibbles[1]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.transport = tokens[2];
        this.name = tokens[3];
        if (tokens.length > 4) {
            this.ssid = tokens[4];
        }
    }

    public String getTransport() {
        return this.transport;
    }

    public byte[] getUID() {
        return this.uid;
    }

    public String getUIDString() {
        return this.uidString;
    }

    public int getPort() {
        return this.port;
    }

    public int getCtrlPort() {
        return this.ctrlPort;
    }

    public String getName() {
        return this.name;
    }

    public String getMachineName() {
        String[] bits = this.name.split("-");
        if (bits != null && bits.length > 1) {
            return bits[0];
        }
        return this.name;
    }

    public String getSessionId() {
        return this.ssid;
    }

    public String toString() {
        return this.getUIDString() + " (" + this.getTransport() + ", " + this.getName() + ")";
    }
}

