/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.InstallerModel;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class FirmwareUpdateStage
extends BaseStage
implements IInstallerStage {
    public static final String FIRMWARE_UPDATER = "/usr/bin/PmFirmwareUpdater";
    private final INovacomDevice device;
    private boolean forceUpdate = false;
    private static final int GATHER_DEVICE_DETAILS = 10;
    private static final int START_FIRMWARE_UPDATER = 10;
    private int currentPercentage = 0;

    public FirmwareUpdateStage(InstallerModel model, INovacomDevice device) throws IOException, NovacomException {
        this.device = device;
    }

    public void setForceUpdate(boolean state) {
        this.forceUpdate = state;
    }

    @Override
    public String toString() {
        return "Firmware Updater";
    }

    private void updatePercentage(IStageProgressReporter progress, Object jobId, int add) {
        this.currentPercentage += add;
        progress.updateJob(jobId, this.currentPercentage);
    }

    @Override
    public void run() throws IOException, NovacomException {
        IStageProgressReporter progress = this.getProgressHandler();
        Object jobId = progress.startJob("Firmware Updater", 100);
        if (!this.device.checkFile(FIRMWARE_UPDATER)) {
            progress.commentOnJob(jobId, "No firmware update for this device");
            progress.endJob(jobId);
            return;
        }
        progress.commentOnJob(jobId, "Firmware Update Started");
        progress.commentOnJob(jobId, "Gathering device details...");
        this.updatePercentage(progress, jobId, 10);
        String[] args = null;
        if (this.forceUpdate) {
            progress.commentOnJob(jobId, "Forcing firmware update, no matter the version.");
        }
        progress.commentOnJob(jobId, "Starting /usr/bin/PmFirmwareUpdater");
        INovacomStream stream = this.device.runProgram(FIRMWARE_UPDATER, args);
        this.updatePercentage(progress, jobId, 10);
        BaseStage.StreamReaderThread thread = new BaseStage.StreamReaderThread(stream, jobId);
        thread.start();
        try {
            progress.commentOnJob(jobId, "Waiting....");
            thread.join();
            progress.commentOnJob(jobId, "Finished!");
        }
        catch (InterruptedException e) {
            progress.endJob(jobId);
            throw new IOException("Reader thread never completed.");
        }
        stream.close();
        progress.endJob(jobId);
    }
}

