/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import com.palm.nova.installer.core.LoggerUtils;
import com.palm.nova.installer.core.MountUtils;
import com.palm.nova.installer.core.TarredInstallerModel;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

public class CustomizationStage
extends BaseStage {
    private static final boolean DEBUG = true;
    private static final String IPKG = "/usr/bin/ipkg";
    private static final String MKDIR = "/bin/mkdir";
    private static final String RM = "/bin/rm";
    private static final String TEMP_ROOTFS = "/tmp_rootfs";
    private static final String TEMP_DIR = "/tmp/customization_ipkgs";
    private static final String RUNNER_NAME = "Customization";
    public static final String MODEM_UPDATER = "/usr/bin/PmModemUpdater";
    private final TarredInstallerModel installerModel;
    private final INovacomDevice device;
    private Object jobId;
    private boolean skipPriPrlSet = false;

    public CustomizationStage(INovacomDevice device, TarredInstallerModel installerModel) {
        this.installerModel = installerModel;
        this.device = device;
    }

    public void setSkipPriPrlSet(boolean skip) {
        this.skipPriPrlSet = skip;
    }

    @Override
    public void run() throws IOException, NovacomException {
        this.jobId = this.progress.startJob(RUNNER_NAME, 100);
        this.progress.commentOnJob(this.jobId, "Creating temp directory for updater files: /tmp/customization_ipkgs");
        this.runCommand(RM, new String[]{"-rf", TEMP_DIR});
        this.runCommand(MKDIR, new String[]{"-p", TEMP_DIR});
        MountUtils mountUtils = new MountUtils(this.device);
        mountUtils.mount(MountUtils.MountParts.ROOTFS, MountUtils.FsType.EXT3, TEMP_ROOTFS);
        this.progress.commentOnJob(this.jobId, "Opening terminal to install IPKGs (see bug NOV-28632)");
        INovacomStream terminal = this.device.openTerminal(0);
        TarInputStream tis = new TarInputStream(this.installerModel.getInputStreamForTar());
        TarEntry entry = null;
        while ((entry = tis.getNextEntry()) != null) {
            this.progress.commentOnJob(this.jobId, entry.getName());
            if (!entry.getName().endsWith("ipk")) continue;
            this.progress.commentOnJob(this.jobId, "Installing " + entry.getName());
            String fileOnDevice = "/tmp/customization_ipkgs/" + entry.getName();
            this.putFile(tis, fileOnDevice);
            terminal.write(("/usr/bin/ipkg -force-overwrite -o /tmp_rootfs install " + fileOnDevice + "\r").getBytes());
            terminal.flush();
        }
        this.progress.commentOnJob(this.jobId, "Closing terminal");
        terminal.write("exit\r".getBytes());
        terminal.flush();
        this.printStreamToProgressReporter(terminal);
        tis.close();
        boolean runPriPrlSetScript = true;
        try {
            this.device.getFile("/tmp_rootfs/usr/lib/modem/priprlset.sh");
        }
        catch (NovacomException e) {
            runPriPrlSetScript = false;
        }
        if (this.skipPriPrlSet) {
            this.progress.commentOnJob(this.jobId, "skipping update pri/prl script");
        }
        if (runPriPrlSetScript && !this.skipPriPrlSet) {
            this.progress.commentOnJob(this.jobId, "running update pri/prl script");
            boolean successStringFound = false;
            INovacomStream stream = this.device.runProgram("/tmp_rootfs/usr/lib/modem/priprlset.sh", new String[]{TEMP_ROOTFS});
            while (true) {
                String line = stream.readLine();
                this.progress.commentOnJob(this.jobId, line);
                if (line.compareTo("") == 0) break;
                if (-1 == line.indexOf("$ Your device is ready for use")) continue;
                successStringFound = true;
            }
            if (successStringFound) {
                this.progress.commentOnJob(this.jobId, "successfully updated pri/prl");
            } else {
                this.progress.commentOnJob(this.jobId, "failed to update pri/prl");
                this.progress.endJob(this.jobId);
                throw new NovacomException(-1, "Error Updating Modem PRI/PRL!!!");
            }
        }
        mountUtils.umount(MountUtils.MountParts.ROOTFS);
        this.progress.endJob(this.jobId);
    }

    @Override
    public String toString() {
        return RUNNER_NAME;
    }

    private void runCommand(String command, String[] args) throws IOException, NovacomException {
        if (args == null) {
            args = new String[]{};
        }
        INovacomStream stream = this.device.runProgram(command, args);
        stream.flush();
        this.printStreamToProgressReporter(stream);
    }

    private void printStreamToProgressReporter(INovacomStream stream) throws IOException, NovacomException {
        this.printStreamToProgressReporter(stream, true);
    }

    private void printStreamToProgressReporter(INovacomStream stream, Boolean closeStream) throws IOException, NovacomException {
        String line = stream.readLine();
        while (line.compareTo("") != 0) {
            this.progress.commentOnJob(this.jobId, line);
            line = stream.readLine();
        }
        if (closeStream.booleanValue()) {
            stream.flush();
            stream.close();
        }
    }

    private void putFile(InputStream fileStream, String filePathOnDevice) {
        if (fileStream == null) {
            throw new IllegalArgumentException("fileStream is null!");
        }
        try {
            INovacomStream outputStream = this.device.putFile(filePathOnDevice);
            long written = outputStream.write(fileStream);
            this.progress.commentOnJob(this.jobId, "written " + written);
            outputStream.closeOutput();
            outputStream.waitForReturnCode();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.progress.commentOnJob(this.jobId, e.getMessage());
            LoggerUtils.getInstance().getLogger("CustomizationStage").log(Level.WARNING, "", e);
        }
    }
}

