/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.InstallerModel;
import com.palm.novacom.NovacomException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TrenchcoatModel {
    private Document document;
    private String[] imageFiles;
    private String bootloader;
    private String rootTarball;
    private String massStorageData = "";
    private String userStorageData = "";
    private boolean doPreserveMsmContents = false;
    private final InstallerModel baseModel;
    private final InstallerModel customizationModel;
    private boolean isLvmInUse = false;
    private boolean rfsSizeOverLimit = false;
    private int resizeRootFS = 0;

    public String[] getFilesInOrder() {
        int extraFiles = 2;
        if (this.massStorageData.compareTo("") != 0) {
            ++extraFiles;
        }
        if (this.userStorageData.compareTo("") != 0) {
            ++extraFiles;
        }
        String[] files = new String[extraFiles + this.imageFiles.length];
        int idx = 0;
        files[idx] = this.bootloader;
        ++idx;
        for (int i = 0; i < this.imageFiles.length; ++i) {
            files[idx] = this.imageFiles[i];
            ++idx;
        }
        files[idx] = this.rootTarball;
        ++idx;
        if (this.userStorageData.compareTo("") != 0) {
            files[idx] = this.userStorageData;
            ++idx;
        }
        if (this.massStorageData.compareTo("") != 0) {
            files[idx] = this.massStorageData;
            ++idx;
        }
        return files;
    }

    private void setupBootloader(InstallerModel model) throws IOException {
        this.bootloader = model.getBootFile().length() > 0 ? model.getBootFile() : "boot-" + model.getTarget() + ".bin";
        long filesize = model.getFileSize(this.bootloader);
        NodeList flashEntries = this.document.getElementsByTagName("Entry");
        for (int i = 0; i < flashEntries.getLength(); ++i) {
            Element element = (Element)flashEntries.item(i);
            if (!element.getAttribute("type").equals("bootloader")) continue;
            element.setAttribute("file", "stdin");
            element.setAttribute("fileSize", Long.toString(filesize));
        }
    }

    private void setupRootTarball(InstallerModel model) throws IOException, NovacomException {
        this.rootTarball = model.getImage() + "-" + model.getTarget() + ".rootfs.tar.gz";
        long filesize = model.getFileSize(this.rootTarball);
        if (this.isLvmInUse) {
            NodeList flashEntries = this.document.getElementsByTagName("File");
            for (int i = 0; i < flashEntries.getLength(); ++i) {
                Element element = (Element)flashEntries.item(i);
                if (!element.getAttribute("file").equals("${NOVATGZ}")) continue;
                element.setAttribute("file", "stdin.tar.gz");
                element.setAttribute("fileSize", Long.toString(filesize));
            }
            this.setupLvmRootFilesystemSize();
        } else {
            long rootFileSystemMinSize = model.getRootFilesystemMinSize();
            long originalRootFilesystemSize = this.getOriginalRootFilesystemSize();
            NodeList flashEntries = this.document.getElementsByTagName("Entry");
            for (int i = 0; i < flashEntries.getLength(); ++i) {
                Element element = (Element)flashEntries.item(i);
                if (element.getAttribute("file").equals("${NOVATGZ}")) {
                    element.setAttribute("file", "stdin.tar.gz");
                    element.setAttribute("fileSize", Long.toString(filesize));
                    continue;
                }
                if (!element.getAttribute("type").equals("fat32") || !this.doPreserveMsmContents) continue;
                element.setAttribute("reformat", "false");
            }
        }
    }

    private void setupImageFiles(InstallerModel model) throws IOException {
        Element element;
        int i;
        NodeList sectionEntries = this.document.getElementsByTagName("Section");
        int imageCount = 0;
        for (i = 0; i < sectionEntries.getLength(); ++i) {
            element = (Element)sectionEntries.item(i);
            if (!element.getAttribute("type").equals("image")) continue;
            ++imageCount;
        }
        this.imageFiles = new String[imageCount];
        imageCount = 0;
        for (i = 0; i < sectionEntries.getLength(); ++i) {
            element = (Element)sectionEntries.item(i);
            if (!element.getAttribute("type").equals("image")) continue;
            this.imageFiles[imageCount] = element.getAttribute("file");
            long filesize = model.getFileSize(this.imageFiles[imageCount]);
            element.setAttribute("file", "stdin");
            element.setAttribute("fileSize", Long.toString(filesize));
            ++imageCount;
        }
    }

    public void initDmSetsToken() throws FileNotFoundException, NovacomException {
        this.initDmSetsToken(null, null);
    }

    public void initDmSetsToken(String defaultBaseToken, String defaultCustToken) throws NovacomException, FileNotFoundException {
        if (null == this.baseModel) {
            throw new NovacomException(-1, "baseModel unset");
        }
        StringBuffer buffer = new StringBuffer("{");
        String baseToken = this.baseModel.getDMSetToken();
        if (baseToken.equals("0")) {
            if (null != defaultBaseToken) {
                baseToken = defaultBaseToken;
            } else {
                throw new NovacomException(-1, "base token 0 and no default provided");
            }
        }
        if (null != (buffer = buffer.append("\"sets\":\"" + baseToken + "\"")) && null != this.customizationModel) {
            String custToken = this.customizationModel.getDMSetToken();
            if (custToken.equals("0")) {
                if (null != defaultCustToken) {
                    custToken = defaultCustToken;
                } else {
                    throw new NovacomException(-1, "cust token 0 and no default provided");
                }
            }
            buffer.append(",\"" + custToken + "\"");
        }
        buffer.append("}");
        Token token = new Token("DMSETS", buffer.toString(), true);
        this.addToken(token);
    }

    public void initBatteryCheckToken() throws NovacomException {
        if (null == this.baseModel) {
            throw new NovacomException(-1, "baseModel unset");
        }
        try {
            String baseToken = this.baseModel.getBatteryCheckToken();
            EnvVar token = new EnvVar("checkbatt", baseToken, true);
            this.addEnvVar(token);
        }
        catch (FileNotFoundException e) {
            System.out.println(" no battery check token");
        }
    }

    public TrenchcoatModel(InstallerModel baseModel, InstallerModel customizationModel, int resizeRootFS) throws IOException, NovacomException {
        this.resizeRootFS = resizeRootFS;
        this.baseModel = baseModel;
        this.customizationModel = customizationModel;
        String filename = baseModel.getTarget() + ".xml";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(baseModel.getInputStream(filename));
        }
        catch (Exception e) {
            throw new IOException(filename + " cannot be parsed.");
        }
        NodeList flashEntries = this.document.getElementsByTagName("Entry");
        for (int i = 0; i < flashEntries.getLength() && !this.isLvmInUse; ++i) {
            Element element = (Element)flashEntries.item(i);
            if (!element.getAttribute("type").equals("lvm")) continue;
            this.isLvmInUse = true;
        }
        this.setupBootloader(baseModel);
        this.setupRootTarball(baseModel);
        this.setupImageFiles(baseModel);
        this.massStorageData = "";
        this.userStorageData = "";
    }

    public TrenchcoatModel(InstallerModel baseModel, InstallerModel customizationModel) throws IOException, NovacomException {
        this.baseModel = baseModel;
        this.customizationModel = customizationModel;
        String filename = baseModel.getTarget() + ".xml";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(baseModel.getInputStream(filename));
        }
        catch (Exception e) {
            throw new IOException(filename + " cannot be parsed.");
        }
        NodeList flashEntries = this.document.getElementsByTagName("Entry");
        for (int i = 0; i < flashEntries.getLength() && !this.isLvmInUse; ++i) {
            Element element = (Element)flashEntries.item(i);
            if (!element.getAttribute("type").equals("lvm")) continue;
            this.isLvmInUse = true;
        }
        this.setupBootloader(baseModel);
        this.setupRootTarball(baseModel);
        this.setupImageFiles(baseModel);
        this.massStorageData = "";
        this.userStorageData = "";
    }

    public String toXMLString() throws TransformerException {
        DOMSource source = new DOMSource(this.document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
        return writer.toString();
    }

    private Element getNvramSection(String name) {
        NodeList flashEntries = this.document.getElementsByTagName("Entry");
        for (int i = 0; i < flashEntries.getLength(); ++i) {
            Element element = (Element)flashEntries.item(i);
            if (!element.getAttribute("type").equals("nvram")) continue;
            NodeList nvramSections = element.getElementsByTagName("Section");
            for (int j = 0; j < nvramSections.getLength(); ++j) {
                Element section = (Element)nvramSections.item(j);
                if (!section.getAttribute("type").equals(name)) continue;
                return section;
            }
            return null;
        }
        return null;
    }

    public boolean addToken(Token token) {
        Element section = this.getNvramSection("token");
        if (section != null) {
            Element tokenElement = this.document.createElement("Val");
            tokenElement.setAttribute("name", token.name);
            tokenElement.setAttribute("value", token.value);
            if (token.overwrite) {
                tokenElement.setAttribute("action", "overwrite");
            }
            section.appendChild(tokenElement);
            return true;
        }
        return false;
    }

    public Token[] getTokens() {
        Element section = this.getNvramSection("token");
        NodeList tokenList = section.getElementsByTagName("Val");
        Token[] tokens = new Token[tokenList.getLength()];
        for (int i = 0; i < tokens.length; ++i) {
            Element token = (Element)tokenList.item(i);
            tokens[i] = new Token(token.getAttribute("name"), token.getAttribute("value"), false);
        }
        return tokens;
    }

    public boolean addEnvVar(EnvVar env) {
        Element section = this.getNvramSection("env");
        if (section != null) {
            Element tokenElement = this.document.createElement("Val");
            tokenElement.setAttribute("name", env.name);
            tokenElement.setAttribute("value", env.value);
            if (env.overwrite) {
                tokenElement.setAttribute("action", "overwrite");
            }
            section.appendChild(tokenElement);
            return true;
        }
        return false;
    }

    public EnvVar[] getEnvVars() {
        Element section = this.getNvramSection("env");
        NodeList envVarList = section.getElementsByTagName("Val");
        EnvVar[] vars = new EnvVar[envVarList.getLength()];
        for (int i = 0; i < vars.length; ++i) {
            Element var = (Element)envVarList.item(i);
            vars[i] = new EnvVar(var.getAttribute("name"), var.getAttribute("value"), false);
        }
        return vars;
    }

    public InstallerModel getInstallerModel() {
        return this.baseModel;
    }

    public long getOriginalRootFilesystemSize() throws IOException {
        String originalSize = null;
        NodeList flashEntries = this.document.getElementsByTagName("Entry");
        for (int i = 0; i < flashEntries.getLength(); ++i) {
            Element element = (Element)flashEntries.item(i);
            if (!element.getAttribute("file").equals("${NOVATGZ}")) continue;
            originalSize = element.getAttribute("size");
            if (originalSize.endsWith("MB")) {
                originalSize = originalSize.substring(0, originalSize.length() - 2);
                continue;
            }
            throw new IOException("Parse error. Expected the \"size\" value to have the text \"MB\" at the end.");
        }
        if (originalSize != null) {
            return Long.valueOf(originalSize) * 1024L * 1024L;
        }
        throw new IOException("Parse error.  Original RootFilesystem value was not found in Trenchcoat xml document.");
    }

    private static final long roundUp(long n, long r) {
        return (n += r - 1L) - n % r;
    }

    private static final String rstrip(String s, int n) {
        return s.substring(0, s.length() - n);
    }

    public static long parseSize(String sizeStr) {
        long factor = 1L;
        if (sizeStr.endsWith("GB")) {
            sizeStr = TrenchcoatModel.rstrip(sizeStr, 2);
            factor = 0x40000000L;
        } else if (sizeStr.endsWith("MB")) {
            sizeStr = TrenchcoatModel.rstrip(sizeStr, 2);
            factor = 0x100000L;
        } else if (sizeStr.endsWith("KB")) {
            sizeStr = TrenchcoatModel.rstrip(sizeStr, 2);
            factor = 1024L;
        }
        return Long.valueOf(sizeStr) * factor;
    }

    public void setupLvmRootFilesystemSize() throws IOException, NovacomException {
        String originalSize = null;
        NodeList groupEntries = this.document.getElementsByTagName("Group");
        for (int g = 0; g < groupEntries.getLength(); ++g) {
            Element PEnode = (Element)groupEntries.item(g);
            long PEsize = 0x800000L;
            String PEstr = PEnode.getAttribute("physicalextentsize");
            if (PEstr != null) {
                PEsize = TrenchcoatModel.parseSize(PEstr);
            }
            NodeList flashEntries = PEnode.getElementsByTagName("Volume");
            for (int i = 0; i < flashEntries.getLength(); ++i) {
                Element element = (Element)flashEntries.item(i);
                if (!element.getAttribute("mount").equals("/")) continue;
                originalSize = element.getAttribute("size");
                long parsedOriginalSize = 0L;
                if (originalSize == null) {
                    throw new IOException("Parse error.  Original RootFilesystem value was not found in Trenchcoat xml document.");
                }
                parsedOriginalSize = TrenchcoatModel.parseSize(originalSize);
                if (this.resizeRootFS <= 0) continue;
                element.setAttribute("size", (parsedOriginalSize += TrenchcoatModel.roundUp(this.resizeRootFS * 1024 * 1024, PEsize)) + "");
            }
        }
    }

    public boolean isUsingLvm() throws IOException {
        return this.isLvmInUse;
    }

    protected void addFilesystemTarball(String devicePath, File tarball) throws IOException, NovacomException {
        long filesize = tarball.length();
        if (this.isLvmInUse) {
            NodeList temp = this.document.getElementsByTagName("File");
            Element firstFile = (Element)temp.item(0);
            Element parent = (Element)firstFile.getParentNode();
            Element newFileEntry = this.document.createElement("File");
            newFileEntry.setAttribute("file", "stdin.tar.gz");
            newFileEntry.setAttribute("fileSize", Long.toString(filesize));
            newFileEntry.setAttribute("target", devicePath);
            parent.appendChild(newFileEntry);
        } else {
            NodeList flashEntries = this.document.getElementsByTagName("Entry");
            for (int i = 0; i < flashEntries.getLength(); ++i) {
                Element element = (Element)flashEntries.item(i);
                if (!element.getAttribute("mountPoint").equals(devicePath)) continue;
                if (tarball.getName().endsWith("tar.gz")) {
                    element.setAttribute("file", "stdin.tar.gz");
                } else {
                    element.setAttribute("file", "stdin.tar");
                }
                element.setAttribute("fileSize", Long.toString(filesize));
            }
        }
    }

    protected void addFilesystemTarball(String devicePath, String tarballPath) throws IOException, NovacomException {
        this.addFilesystemTarball(devicePath, new File(tarballPath));
    }

    public void addMassStorageData(String tarballPath) throws IOException, NovacomException {
        this.addFilesystemTarball("/media/internal", new File(tarballPath));
        this.massStorageData = tarballPath;
    }

    public void addUserStorageData(String tarballPath) throws IOException, NovacomException {
        this.addFilesystemTarball("/var", new File(tarballPath));
        this.userStorageData = tarballPath;
    }

    public void doPreserveMsmContents(boolean doSaveMsm) {
        this.doPreserveMsmContents = doSaveMsm;
        if (this.doPreserveMsmContents) {
            NodeList flashEntries = this.document.getElementsByTagName("Volume");
            for (int i = 0; i < flashEntries.getLength(); ++i) {
                Element element = (Element)flashEntries.item(i);
                if (!element.getAttribute("id").equals("media")) continue;
                element.setAttribute("reformat", "false");
            }
        }
    }

    public String getLvmGroupName() throws NovacomException {
        String groupName = null;
        NodeList flashEntries = this.document.getElementsByTagName("Group");
        if (0 < flashEntries.getLength()) {
            Element element = (Element)flashEntries.item(0);
            groupName = element.getAttribute("name");
        }
        if (null == groupName) {
            throw new NovacomException(-1, "Error getting LVM Volume Name");
        }
        return groupName;
    }

    private String getLvmVolumeId(String mountPoint) {
        String volName = null;
        NodeList flashEntries = this.document.getElementsByTagName("Volume");
        for (int i = 0; i < flashEntries.getLength() && null == volName; ++i) {
            Element element = (Element)flashEntries.item(i);
            if (!element.getAttribute("mount").equals(mountPoint)) continue;
            volName = element.getAttribute("id");
        }
        return volName;
    }

    public String getLvmVarFsVolumeName() throws NovacomException {
        String volName = this.getLvmVolumeId("/var");
        if (null == volName) {
            throw new NovacomException(-1, "Error getting Var LVM Volume Name");
        }
        return volName;
    }

    public String getLvmRootFsVolumeName() throws NovacomException {
        String volName = this.getLvmVolumeId("/");
        if (null == volName) {
            throw new NovacomException(-1, "Error getting Rooot LVM Volume Name");
        }
        return volName;
    }

    public boolean getRFSOverLimitStatus() {
        return this.rfsSizeOverLimit;
    }

    class EnvVar {
        public final String name;
        public final String value;
        public final boolean overwrite;

        public EnvVar(String name, String value, boolean overwrite) {
            this.name = name;
            this.value = value;
            this.overwrite = overwrite;
        }
    }

    class Token {
        public final String name;
        public final String value;
        public final boolean overwrite;

        public Token(String name, String value, boolean overwrite) {
            this.name = name;
            this.value = value;
            this.overwrite = overwrite;
        }
    }
}

