/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.MountUtils;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class VerifyRomStage
extends BaseStage {
    private static final String TEMP_ROOTFS = "/tmp_rootfs";
    private static final String RUNNER_NAME = "ROM Verifyer";
    private static final String INTEGCHCK = "/usr/sbin/integcheck";

    public VerifyRomStage(INovacomDevice device) {
        super(device);
    }

    @Override
    public void run() throws IOException, NovacomException {
        this.progress = this.getProgressHandler();
        this.jobId = this.progress.startJob(RUNNER_NAME, 100);
        MountUtils mountUtils = new MountUtils(this.device);
        mountUtils.mount(MountUtils.MountParts.ROOTFS, MountUtils.FsType.EXT3, TEMP_ROOTFS, true);
        mountUtils.mount(MountUtils.MountParts.BOOTFS, MountUtils.FsType.EXT3, "/tmp_rootfs/boot", true);
        this.progress.commentOnJob(this.jobId, "Starting Check of ROM");
        this.runCommand(INTEGCHCK, new String[]{"-r", TEMP_ROOTFS, "ipkg"});
        mountUtils.umount(MountUtils.MountParts.BOOTFS);
        mountUtils.umount(MountUtils.MountParts.ROOTFS);
        this.progress.endJob(this.jobId);
    }

    @Override
    public String toString() {
        return RUNNER_NAME;
    }

    @Override
    protected void printStreamToProgressReporter(INovacomStream stream, Boolean closeStream) throws IOException, NovacomException {
        String line = stream.readLine();
        while (line.compareTo("") != 0) {
            this.getProgressHandler().commentOnJob(this.jobId, line);
            if (line.contains("VERIFICATION FAILED")) {
                throw new NovacomException(-1, 30, "Base ROM Failed Verification");
            }
            line = stream.readLine();
        }
        if (closeStream.booleanValue()) {
            stream.flush();
            stream.close();
        }
    }
}

