/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.MountUtils;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class SaveLogsBeforeFlashStage
extends BaseStage {
    private static final String RUNNER_NAME = "SaveLogsBeforeFlash";
    private static final String RM = "/bin/rm";
    private static final String MKDIR = "/bin/mkdir";
    private static final String TEMP_MEDIAFS = "/tmp_media";
    private static final String TEMP_LOG = "/tmp_log";
    private static final String COLLECT_LOGS = "/usr/local/sbin/recovery/save_logs.sh";

    public SaveLogsBeforeFlashStage(INovacomDevice device) {
        super(device);
    }

    @Override
    public void run() throws IOException, NovacomException {
        IStageProgressReporter reporter = this.getProgressHandler();
        this.jobId = reporter.startJob(RUNNER_NAME, 100);
        if (!this.device.checkFile(COLLECT_LOGS)) {
            reporter.commentOnJob(this.jobId, "No recovery utilities for this device.. not saving logs");
            reporter.endJob(this.jobId);
            return;
        }
        reporter.commentOnJob(this.jobId, "saving logs before flashing ");
        this.runCommand(RM, new String[]{"-rf", TEMP_MEDIAFS});
        this.runCommand(MKDIR, new String[]{"-p", TEMP_MEDIAFS});
        this.runCommand(RM, new String[]{"-rf", TEMP_LOG});
        this.runCommand(MKDIR, new String[]{"-p", TEMP_LOG});
        MountUtils mountUtils = new MountUtils(this.device);
        mountUtils.mount(MountUtils.MountParts.MEDIAFS, MountUtils.FsType.VFAT, TEMP_MEDIAFS);
        mountUtils.mount(MountUtils.MountParts.LOGFS, MountUtils.FsType.EXT3, TEMP_LOG);
        reporter.commentOnJob(this.jobId, "mounted mediafs and logfs sucessfully");
        INovacomStream stream = this.device.runProgram(COLLECT_LOGS, new String[0]);
        stream.flush();
        String line = stream.readLine();
        while (line.compareTo("") != 0) {
            reporter.commentOnJob(this.jobId, line);
            line = stream.readLine();
        }
        stream.flush();
        int retCode = stream.waitForReturnCode();
        if (retCode != 0) {
            reporter.commentOnJob(this.jobId, "WARNING:: Issue with saving logs");
        }
        stream.close();
        reporter.commentOnJob(this.jobId, "Done with SaveLog stage");
        mountUtils.umount(MountUtils.MountParts.MEDIAFS);
        mountUtils.umount(MountUtils.MountParts.LOGFS);
        reporter.endJob(this.jobId);
    }

    @Override
    public String toString() {
        return RUNNER_NAME;
    }
}

