/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.RdxUtils;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.NovacomException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class RdxUploadStage
extends BaseStage
implements IInstallerStage {
    private RdxUtils rdxUtils;

    public RdxUploadStage(INovacomDevice device) throws IOException, NovacomException {
        super(device);
    }

    @Override
    public String toString() {
        return "Rdx upload stage";
    }

    @Override
    public void run() throws IOException, NovacomException {
        IStageProgressReporter progress = this.getProgressHandler();
        this.jobId = progress.startJob("rdx upload stage", 100);
        progress.commentOnJob(this.jobId, "rdx upload started");
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith("/") && !tempDir.endsWith("\\")) {
            tempDir = tempDir + System.getProperty("file.separator");
        }
        progress.commentOnJob(this.jobId, "Check for error logs " + tempDir);
        File fileDir = new File(tempDir);
        File[] files = fileDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("PalmWebOsRecoveryToolLog");
            }
        });
        if (files.length > 0) {
            this.rdxUtils = new RdxUtils(this.device);
            progress.commentOnJob(this.jobId, "copying error logs to rdx");
            this.rdxUtils.putFilesInRdxFolder(files);
        } else {
            progress.commentOnJob(this.jobId, "no error logs found");
        }
        progress.endJob(this.jobId);
    }
}

