/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.InstallerModel;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class FirmwareUpdateStage
extends BaseStage
implements IInstallerStage {
    public static final String FIRMWARE_UPDATER = "/usr/bin/PmFirmwareUpdater";
    private boolean forceUpdate = false;
    private static final int GATHER_DEVICE_DETAILS = 10;
    private static final int START_FIRMWARE_UPDATER = 10;
    private int currentPercentage = 0;

    public FirmwareUpdateStage(InstallerModel model, INovacomDevice device) throws IOException, NovacomException {
        super(device);
    }

    public void setForceUpdate(boolean state) {
        this.forceUpdate = state;
    }

    @Override
    public String toString() {
        return "Firmware Updater";
    }

    private void updatePercentage(IStageProgressReporter progress, Object jobId, int add) {
        this.currentPercentage += add;
        progress.updateJob(jobId, this.currentPercentage);
    }

    @Override
    public void run() throws IOException, NovacomException {
        this.progress = this.getProgressHandler();
        this.jobId = this.progress.startJob("Firmware Updater", 100);
        if (!this.device.checkFile(FIRMWARE_UPDATER)) {
            this.progress.commentOnJob(this.jobId, "No firmware update for this device");
            this.progress.endJob(this.jobId);
            return;
        }
        this.progress.commentOnJob(this.jobId, "Firmware Update Started");
        this.progress.commentOnJob(this.jobId, "Gathering device details...");
        this.updatePercentage(this.progress, this.jobId, 10);
        String[] args = null;
        if (this.forceUpdate) {
            this.progress.commentOnJob(this.jobId, "Forcing firmware update, no matter the version.");
        }
        this.progress.commentOnJob(this.jobId, "Starting /usr/bin/PmFirmwareUpdater");
        INovacomStream stream = this.device.runProgram(FIRMWARE_UPDATER, args);
        this.updatePercentage(this.progress, this.jobId, 10);
        BaseStage.StreamReaderThread thread = new BaseStage.StreamReaderThread(this, stream, this.jobId);
        thread.start();
        try {
            this.progress.commentOnJob(this.jobId, "Waiting....");
            thread.join();
            this.progress.commentOnJob(this.jobId, "Finished!");
        }
        catch (InterruptedException e) {
            this.progress.endJob(this.jobId);
            throw new IOException("Reader thread never completed.");
        }
        stream.close();
        this.progress.endJob(this.jobId);
    }
}

