/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.BootieUtilities;
import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.nova.installer.core.stages.GoIntoUpdateModeStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class ChargeBatteryStage
extends BaseStage
implements IInstallerStage {
    private static final int REQUIRED_POWER_PERCENTAGE = 25;
    private static final int HYSTERESIS = 3;
    private static final int RECHARGE_RETRY_COUNT = 5;
    static final String WALL_CHARGE_DMMODELS = "HSTNH-I30C,HSTNH-I29C,HSTNH-I31C,HSTNH-I32C,HSTNH-I33C";
    private IStageProgressReporter progress = null;
    private int currentChargeLevel = 0;

    public ChargeBatteryStage(INovacomDevice device) {
        super(device);
    }

    @Override
    public String toString() {
        return "Battery Charger";
    }

    private void chargeBattery(boolean doWait) throws NovacomException, IOException {
        INovacomStream stream = this.device.runProgram("", null);
        String command = "charging enable 25";
        byte[] bytes = command.getBytes("US-ASCII");
        stream.write(bytes);
        stream.closeOutput();
        if (!doWait) {
            stream.close();
            return;
        }
        String streamReturn = stream.readLine();
        while (true) {
            int end;
            if ((streamReturn = stream.readLine()) == null) {
                this.progress.commentOnJob(this.jobId, "stream interupted");
                throw new NovacomException(-1, 5, "stream interupted");
            }
            if (streamReturn.length() == 0) break;
            int start = streamReturn.indexOf("p=");
            if (start >= 0 && (end = streamReturn.indexOf(" ", start + 2)) >= 2) {
                String strReadBatteryPercentage = streamReturn.substring(start += 2, end);
                try {
                    int readBatteryPercentage = new Integer(strReadBatteryPercentage);
                    if (readBatteryPercentage > this.currentChargeLevel) {
                        this.currentChargeLevel = readBatteryPercentage;
                        this.progress.updateJob(this.jobId, this.currentChargeLevel);
                        this.progress.commentOnJob(this.jobId, "battery percentage changed: " + this.currentChargeLevel);
                    }
                    Thread.sleep(500L);
                }
                catch (NumberFormatException e) {
                    this.progress.commentOnJob(this.jobId, "+++++" + streamReturn + "-----");
                }
                catch (InterruptedException e) {}
            } else {
                this.progress.commentOnJob(this.jobId, "+++++" + streamReturn + "-----");
            }
            stream.flush();
        }
        this.progress.commentOnJob(this.jobId, "power charged up");
        stream.close();
    }

    @Override
    public void run() throws NovacomException, IOException {
        BootieUtilities bootie;
        int currentPercentage;
        this.progress = this.getProgressHandler();
        this.jobId = this.progress.startJob("Battery Charger Stage", 100);
        if (this.device.getState() != Novacom.DeviceState.BOOTLOADER) {
            GoIntoUpdateModeStage intoUpdateMode = new GoIntoUpdateModeStage(this.device);
            intoUpdateMode.run();
        }
        if (22 > (currentPercentage = (bootie = new BootieUtilities(this.device)).checkPowerStatus().intValue())) {
            if (WALL_CHARGE_DMMODELS.contains(bootie.getDMModel())) {
                this.chargeBattery(false);
                throw new NovacomException(-1, 26, "NEED WALL CHARGING: battery will only charge from wall jack");
            }
            this.progress.commentOnJob(this.jobId, "Battery at " + currentPercentage + "%");
            int count = 0;
            do {
                this.progress.commentOnJob(this.jobId, "Battery Charging Started");
                this.progress.commentOnJob(this.jobId, "Charging to Sufficient Power (25%), this may take a couple of minutes");
                this.chargeBattery(true);
                if (++count <= 5) continue;
                throw new NovacomException(-1, 25, "failed to charge battery");
            } while (22 > this.currentChargeLevel);
        }
        this.progress.endJob(this.jobId);
    }
}

