/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.InstallerModel;
import com.palm.nova.installer.core.MountUtils;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BonusloadStage
extends BaseStage {
    private static final String RUNNER_NAME = "Bonusload";
    private static final String TAR = "/bin/tar";
    private static final String TEMP_ROOTFS = "/tmp_rootfs";
    private final InstallerModel[] bonusLoads;

    public BonusloadStage(INovacomDevice device, InstallerModel[] loads) {
        super(device);
        this.bonusLoads = loads;
    }

    @Override
    public void run() throws IOException, NovacomException {
        this.progress = this.getProgressHandler();
        this.jobId = this.progress.startJob(RUNNER_NAME, this.bonusLoads.length);
        this.progress.commentOnJob(this.jobId, "flashing bonus material");
        MountUtils mountUtils = new MountUtils(this.device);
        mountUtils.mountAll(TEMP_ROOTFS);
        for (int i = 0; i < this.bonusLoads.length; ++i) {
            String image;
            InstallerModel model = this.bonusLoads[i];
            String name = model.getName();
            if (name == null || name.length() == 0) {
                name = model.getImage();
            }
            if ((image = model.getImage()) == null || image.length() == 0) {
                throw new NovacomException(-1, 60, "Image property not set in bonus file " + name);
            }
            String destdir = model.getDestination();
            if (destdir == null || destdir.length() == 0) {
                throw new NovacomException(-1, 60, "destination property not set in bonus file " + name);
            }
            destdir = TEMP_ROOTFS + destdir;
            InputStream tis = model.getInputStream(image);
            this.progress.commentOnJob(this.jobId, "Unpacking file " + image + " to " + model.getDestination());
            INovacomStream stream = this.device.runProgram(TAR, new String[]{"xzf", "-", "-C", destdir});
            long count = this.write(stream, tis, model.getFileSize(image));
            tis.close();
            stream.close();
            this.progress.commentOnJob(this.jobId, "Sent " + count + " bytes");
            this.progress.commentOnJob(this.jobId, "bonus file " + name + " flashed ");
            this.progress.updateJob(this.jobId, i + 1);
        }
        mountUtils.umountAll();
        this.progress.endJob(this.jobId);
    }

    private long write(INovacomStream out, InputStream in, long size) throws IOException {
        int count;
        BufferedInputStream buffstream = new BufferedInputStream(in, 0x100000);
        byte[] buffer = new byte[16384];
        long total = 0L;
        long pct = 0L;
        while (total < size && (count = buffstream.read(buffer)) != -1) {
            out.write(buffer, 0, count);
            long p = (total += (long)count) * 20L / size;
            if (p == pct) continue;
            this.progress.commentOnJob(this.jobId, "sent " + total + " bytes -- " + p * 5L + '%');
            pct = p;
        }
        return total;
    }

    @Override
    public String toString() {
        return RUNNER_NAME;
    }
}

