/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.StringUtilities;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.util.HashMap;

public class TokenReader {
    public static final String TOKENS_UTIL = "/sbin/tokens";
    public static final String[] TOKENS_ARGS = new String[]{"--list"};
    public static final String TOKENS_BOOTIE = "token dump";
    private HashMap<String, String> tokens = new HashMap();

    public TokenReader(INovacomDevice device) throws IOException, NovacomException {
        Novacom.DeviceState state = device.getState();
        switch (state) {
            case UNKNOWN: {
                throw new NovacomException(-1, 37, "Unable to read device tokens");
            }
            case BOOTLOADER: {
                this.bootieTokens(device);
                break;
            }
            case INSTALLER: 
            case OS: {
                this.osTokens(device);
            }
        }
    }

    private void osTokens(INovacomDevice device) throws NovacomException, IOException {
        INovacomStream stream = device.runProgram(TOKENS_UTIL, TOKENS_ARGS);
        String line = stream.readLine();
        while (line.length() > 0) {
            if (line.indexOf("<INFO>") == 0) {
                this.parseLine(line);
            }
            line = stream.readLine();
        }
    }

    private void parseLine(String line) {
        StringBuffer buffer = new StringBuffer(line);
        buffer.delete(0, 7);
        String[] pair = buffer.toString().split(" = ");
        if (pair != null && pair.length > 1) {
            StringBuffer name = new StringBuffer(StringUtilities.trim(pair[0]));
            StringBuffer value = new StringBuffer(StringUtilities.trim(pair[1]));
            name.deleteCharAt(0);
            name.deleteCharAt(name.length() - 1);
            value.deleteCharAt(0);
            while (value.length() > 0) {
                int idx = value.length() - 1;
                char val = value.charAt(idx);
                value.deleteCharAt(idx);
                if (val != '\"') continue;
                break;
            }
            if (name.length() > 0) {
                this.tokens.put(name.toString(), value.toString());
            }
        }
    }

    private void bootieTokens(INovacomDevice device) throws NovacomException, IOException {
        String temp;
        INovacomStream stream = device.runProgram("", null);
        String command = TOKENS_BOOTIE;
        byte[] bytes = command.getBytes("US-ASCII");
        stream.write(bytes);
        stream.closeOutput();
        while ((temp = stream.readLine()) != null && temp.length() > 0) {
            String[] toks = temp.trim().split(", *");
            if (toks.length < 5 || !toks[3].startsWith("name '") || !toks[4].startsWith("value '")) continue;
            String name = toks[3].substring(5).replaceAll("'", "");
            String value = toks[4].substring(6).replaceAll("'", "");
            this.tokens.put(name, value);
        }
        stream.close();
    }

    public boolean isTokenPresent(String name) {
        String value = this.tokens.get(name);
        return value != null;
    }

    public String getTokenValue(String name) {
        String value = this.tokens.get(name);
        if (value != null) {
            return value;
        }
        return "";
    }
}

