/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.LoggerUtils;
import com.palm.nova.installer.core.ModemUtilities;
import com.palm.nova.installer.core.MountUtils;
import com.palm.nova.installer.core.StringUtilities;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeviceInfo {
    private INovacomDevice device;
    private HashMap<String, String> buildInfo;
    private HashMap<String, String> customizationInfo;
    private HashMap<String, String> modemInfo;
    private HashMap<String, String> touchPanelInfo;
    private String deviceName;
    private String serverSoftwareUpdateFile;
    private MountUtils mountUtils;
    private Boolean ckPowerCycleModem = false;
    private boolean hasModem = true;
    private static final String TMP_ROOTFS = "/tmp_rootfs";
    private static final Logger logger = LoggerUtils.getInstance().getLogger("DeviceInfo");

    private void gatherPalmBuildInfo() throws IOException, NovacomException {
        String[] pairs;
        INovacomStream output;
        Novacom.DeviceState deviceState = this.device.getState();
        String rootFsPrepend = "";
        try {
            if (deviceState == Novacom.DeviceState.INSTALLER) {
                logger.info("verified installer mode");
                this.mountUtils = new MountUtils(this.device);
                this.mountUtils.mount(MountUtils.MountParts.ROOTFS, MountUtils.FsType.EXT3, TMP_ROOTFS);
                rootFsPrepend = TMP_ROOTFS;
            }
        }
        catch (NovacomException e) {
            logger.log(Level.WARNING, "failed to mount rootfs from ramdisk, device probably has no root image", e);
            return;
        }
        try {
            output = this.device.getFile(rootFsPrepend + "/etc/palm-build-info");
        }
        catch (NovacomException e) {
            if (deviceState == Novacom.DeviceState.INSTALLER) {
                logger.info("mount not complete wait and try 1 more time");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                try {
                    output = this.device.getFile(rootFsPrepend + "/etc/palm-build-info");
                }
                catch (NovacomException e2) {
                    try {
                        this.mountUtils.umount(MountUtils.MountParts.ROOTFS);
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                    logger.log(Level.WARNING, "", e);
                    return;
                }
            }
            throw e;
        }
        String line = output.readLine();
        logger.fine(line);
        while (line.length() > 0) {
            pairs = line.split("=");
            this.buildInfo.put(StringUtilities.trim(pairs[0]), StringUtilities.trim(pairs[1]));
            line = output.readLine();
            logger.fine(line);
        }
        output.close();
        try {
            output = this.device.getFile(rootFsPrepend + "/etc/palm/palm-customization-info");
            line = output.readLine();
            while (line.length() > 0) {
                pairs = line.split("=");
                logger.config("\"" + StringUtilities.trim(pairs[0]) + "\",\"" + StringUtilities.trim(pairs[1]) + "\"");
                this.customizationInfo.put(StringUtilities.trim(pairs[0]), StringUtilities.trim(pairs[1]));
                line = output.readLine();
            }
            output.close();
        }
        catch (NovacomException e) {
            logger.log(Level.WARNING, "palm-customization-info file not found, not expected if in ramdisk");
        }
        catch (ConnectException e) {
            logger.log(Level.WARNING, "palm-customization-info file not found, not expected if in ramdisk");
        }
        if (deviceState == Novacom.DeviceState.INSTALLER) {
            this.mountUtils.umount(MountUtils.MountParts.ROOTFS);
        }
    }

    private void gatherServerSoftwareUpdateFile() throws IOException {
        try {
            String line;
            INovacomStream output = this.device.runProgram("/bin/ls", new String[]{"-1 /usr/share/omadm/"});
            while (null != (line = output.readLine()) && 0 != line.length() && null == this.serverSoftwareUpdateFile) {
                if ("internal".equals(line = line.trim())) {
                    this.serverSoftwareUpdateFile = line;
                    continue;
                }
                if ("beta".equals(line)) {
                    this.serverSoftwareUpdateFile = line;
                    continue;
                }
                if ("carrier".equals(line)) {
                    this.serverSoftwareUpdateFile = line;
                    continue;
                }
                if (!"production".equals(line)) continue;
                this.serverSoftwareUpdateFile = line;
            }
        }
        catch (NovacomException e) {
            logger.log(Level.WARNING, "file not found", e);
        }
        catch (ConnectException e) {
            logger.log(Level.WARNING, "connection failed", e);
        }
    }

    private void gatherModemInfo() throws IOException, NovacomException {
        this.modemInfo.put("FW VERSION", "unknown");
        this.modemInfo.put("MODEM MODEL", "unknown");
        this.modemInfo.put("MEID", "unknown");
        boolean powerCycleModem = true;
        if (this.ckPowerCycleModem.booleanValue()) {
            INovacomStream updaterOut = null;
            try {
                StringBuffer script = new StringBuffer("#!/bin/sh\n");
                script.append("/usr/bin/ipkg list | /bin/grep -ni pmmodeminfo | /usr/bin/awk '{print $3}'\n");
                script.append("\n");
                updaterOut = this.device.putFile("/tmp/query_pmmodeminfopkg.sh");
                updaterOut.write(script.toString().getBytes("US-ASCII"));
                updaterOut.closeInput();
                updaterOut.closeOutput();
                updaterOut.waitForReturnCode();
                updaterOut.close();
                updaterOut = this.device.runProgram("/bin/sh", new String[]{"-c", "/tmp/query_pmmodeminfopkg.sh"});
                String ipkgVersion = updaterOut.readLine();
                int returnCode = updaterOut.waitForReturnCode();
                updaterOut.close();
                if (0 == returnCode && ipkgVersion.compareTo("1.0.0-34") >= 0) {
                    logger.log(Level.INFO, "pmmodeminfo version >= 1.0.0-34, skipping modem power cycle per NOV-117212");
                    powerCycleModem = false;
                }
            }
            catch (NovacomException e) {
                logger.log(Level.WARNING, "could not determine pmmodeminfo version, will power cycle modem if possible");
            }
        }
        if (powerCycleModem) {
            try {
                this.device.getFile("/usr/bin/pmmodempower");
                INovacomStream power = this.device.runProgram("/usr/bin/pmmodempower", new String[]{"cycle"});
                power.close();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (NovacomException e) {
                logger.log(Level.WARNING, "could not invoke pmmodempower, ok if running rockhopper");
                return;
            }
        }
        try {
            ModemUtilities.getModemInfo(this.device, this.modemInfo);
            String mtype = this.getModemType();
            if (mtype != null && mtype.startsWith("No Modem")) {
                this.hasModem = false;
            }
        }
        catch (NovacomException e) {
            logger.log(Level.WARNING, "could not invoke PmModemInfo, ok if running rockhopper");
            this.hasModem = false;
            return;
        }
    }

    private void gatherTouchPanelInfo() throws IOException, NovacomException {
        int tpReturnCode = -1;
        int testReturnCode = -1;
        int hidReturnCode = -1;
        String returnLine = "error";
        boolean pmTpUpdaterExists = false;
        boolean lunaSendExists = false;
        boolean awkExists = false;
        INovacomStream updaterOut = null;
        updaterOut = this.device.runProgram("/usr/bin/test", new String[]{"-e", "/usr/bin/PmTpUpdater"});
        testReturnCode = updaterOut.waitForReturnCode();
        updaterOut.close();
        if (0 == testReturnCode) {
            pmTpUpdaterExists = true;
        }
        updaterOut = this.device.runProgram("/usr/bin/test", new String[]{"-e", "/usr/bin/luna-send"});
        testReturnCode = updaterOut.waitForReturnCode();
        updaterOut.close();
        if (0 == testReturnCode) {
            lunaSendExists = true;
        }
        updaterOut = this.device.runProgram("/usr/bin/test", new String[]{"-e", "/usr/bin/awk"});
        testReturnCode = updaterOut.waitForReturnCode();
        updaterOut.close();
        if (0 == testReturnCode) {
            awkExists = true;
        }
        if (pmTpUpdaterExists) {
            try {
                updaterOut = this.device.runProgram("/usr/bin/PmTpUpdater", new String[]{"-g"});
                String line = updaterOut.readLine();
                tpReturnCode = updaterOut.waitForReturnCode();
                if (0 == tpReturnCode) {
                    returnLine = line;
                }
            }
            catch (IOException e) {
                logger.log(Level.INFO, "IOException thrown while attempting to invoke PmTpUpdater");
            }
            catch (NovacomException e) {
                logger.log(Level.INFO, "NovacomException thrown while attempting to invoke PmTpUpdater");
            }
            if (null != updaterOut) {
                updaterOut.close();
            }
        }
        if (0 != tpReturnCode && lunaSendExists && awkExists) {
            try {
                StringBuffer script = new StringBuffer("#!/bin/sh\n");
                script.append("/usr/bin/luna-send -n 1 palm://com.palm.hidd/HidTouchpanel/FirmwareVersion {\\\"mode\\\":\\\"get\\\"} > /tmp/hidd.txt 2>&1\n");
                script.append("\n");
                updaterOut = this.device.putFile("/tmp/query_hidd.sh");
                updaterOut.write(script.toString().getBytes("US-ASCII"));
                updaterOut.closeInput();
                updaterOut.closeOutput();
                updaterOut.waitForReturnCode();
                updaterOut.close();
                updaterOut = this.device.runProgram("/bin/sh", new String[]{"-c", "/tmp/query_hidd.sh"});
                hidReturnCode = updaterOut.waitForReturnCode();
                updaterOut.close();
                if (0 == hidReturnCode) {
                    script = new StringBuffer("#!/bin/sh\n");
                    script.append("grep errorText /tmp/hidd.txt\n");
                    script.append("if [[ $? -eq 0 ]]; then\n");
                    script.append("return -1\n");
                    script.append("else\n");
                    script.append("/usr/bin/awk '{ for (i=1; i <= NF; i++) if (match($i, \"value\")) {gsub(/\\\"/, \"\", $(i+1));sub(/0x/, \"\", $(i+1));print $(i+1)}}' /tmp/hidd.txt\n");
                    script.append("fi\n");
                    script.append("return $?\n");
                    updaterOut = this.device.putFile("/tmp/parse_hidd.sh");
                    updaterOut.write(script.toString().getBytes("US-ASCII"));
                    updaterOut.closeInput();
                    updaterOut.closeOutput();
                    updaterOut.waitForReturnCode();
                    updaterOut.close();
                    updaterOut = this.device.runProgram("/bin/sh", new String[]{"-c", "/tmp/parse_hidd.sh"});
                    String line = updaterOut.readLine();
                    hidReturnCode = updaterOut.waitForReturnCode();
                    updaterOut.close();
                    if (0 == hidReturnCode) {
                        returnLine = line;
                    }
                }
            }
            catch (IOException e) {
                logger.log(Level.INFO, "IO exception when querying hidd", e);
            }
            catch (NovacomException e) {
                logger.log(Level.INFO, "novacom exception when querying hidd", e);
            }
        }
        this.touchPanelInfo.put("fwversion", returnLine);
    }

    private void gatherDeviceName() throws NovacomException, IOException {
        try {
            StringBuffer script = new StringBuffer("#!/bin/sh\n/bin/cat /proc/cmdline | /usr/bin/awk ");
            script.append("'{for(i=1;i<=NF;i++){if($i ~ /boardtype/){print substr($i,11)}}}'");
            script.append("\nexit 0\n");
            INovacomStream output = this.device.putFile("/tmp/getboardtype.sh");
            output.write(script.toString().getBytes("US-ASCII"));
            output.closeInput();
            output.closeOutput();
            output.waitForReturnCode();
            output.close();
            output = this.device.runProgram("/bin/sh", new String[]{"-c /tmp/getboardtype.sh"});
            this.deviceName = StringUtilities.trim(output.readLine());
            output.close();
        }
        catch (NovacomException e) {
            logger.log(Level.WARNING, "novacom exception", e);
        }
        catch (ConnectException e) {
            logger.log(Level.WARNING, "connection exception", e);
        }
    }

    public DeviceInfo(INovacomDevice device) throws IOException, NovacomException {
        this.initValues(device);
    }

    public DeviceInfo(INovacomDevice device, boolean powerCycleModem) throws IOException, NovacomException {
        this.ckPowerCycleModem = powerCycleModem;
        this.initValues(device);
    }

    private void initValues(INovacomDevice device) throws IOException, NovacomException {
        this.device = device;
        this.buildInfo = new HashMap();
        this.customizationInfo = new HashMap();
        this.modemInfo = new HashMap();
        this.touchPanelInfo = new HashMap();
        this.refreshValues();
    }

    public void refreshValues() throws IOException, NovacomException, ConnectException {
        if (this.device.isConnected()) {
            this.gatherPalmBuildInfo();
            this.gatherModemInfo();
            this.gatherTouchPanelInfo();
            this.gatherDeviceName();
            this.gatherServerSoftwareUpdateFile();
        }
    }

    public String getDeviceName() throws IOException, NovacomException {
        return this.deviceName;
    }

    public String getDeviceType() throws IOException, NovacomException {
        return this.deviceName;
    }

    public String getCarrierName() {
        return this.customizationInfo.get("CUSTOMIZATION");
    }

    public String getProductVersion() {
        return this.buildInfo.get("PRODUCT_VERSION_STRING");
    }

    public String getOSVersion() {
        return "0.9";
    }

    public String getBuildName() {
        return this.buildInfo.get("BUILDNAME");
    }

    public String getBuildVersion() {
        return this.buildInfo.get("BUILDNUMBER");
    }

    public String getCustomizationVariant() {
        return this.customizationInfo.get("CUSTOMIZATION");
    }

    public String getCustomizationVersion() {
        return this.customizationInfo.get("BUILDNUMBER");
    }

    public boolean hasAModem() {
        return this.hasModem;
    }

    public String getTouchPanelFwVersion() {
        return this.touchPanelInfo.get("fwversion");
    }

    public String getModemFwVersion() {
        return this.modemInfo.get("FW VERSION");
    }

    public String getModemType() {
        String modemType = this.modemInfo.get("HW RADIO TYPE");
        if (modemType != null) {
            return modemType;
        }
        return this.modemInfo.get("MODEM MODEL");
    }

    public String getSwUpdateServerFile() {
        return this.serverSoftwareUpdateFile;
    }

    public String getModemMeidOrImei() {
        String modemId = "Unknown";
        String modemType = this.getModemType();
        if ("CDMA".equals(modemType) || "CDMA_SPRINT".equals(modemType)) {
            modemId = this.modemInfo.get("MEID");
        } else if ("WORLD".equals(modemType)) {
            modemId = this.modemInfo.get("MEID");
        } else if ("UMTS".equals(modemType)) {
            modemId = this.modemInfo.get("IMEI");
        }
        return modemId;
    }

    public int getBatteryPercentage() throws IOException, NovacomException {
        int percentage = -1;
        INovacomStream lunaSendOut = null;
        String machineName = this.device.getDeviceInfo().getMachineName().toLowerCase();
        if ("broadway" == machineName) {
            lunaSendOut = this.device.runProgram("/bin/cat", new String[]{"/sys/devices/platform/i2c-adapter/i2c-0/0-0031/getpercent"});
        } else {
            lunaSendOut = this.device.runProgram("/bin/cat", new String[]{"/sys/devices/w1_bus_master1/w1_master_slaves"});
            String id = lunaSendOut.readLine();
            System.out.println("id for battery check is : " + id);
            id = id.trim();
            if (id != null && id.length() > 0) {
                lunaSendOut = this.device.runProgram("/bin/cat", new String[]{"/sys/devices/w1_bus_master1/" + id + "/getpercent"});
            } else {
                throw new NovacomException(-1, 23, "could not read ID");
            }
        }
        String strPercent = lunaSendOut.readLine();
        System.out.println("string returned for percent is : " + strPercent);
        if (strPercent == null || strPercent.length() <= 0) {
            throw new NovacomException(-1, 23, "invalid percent reurned");
        }
        strPercent = strPercent.trim();
        percentage = new Integer(strPercent);
        return percentage;
    }

    public String getBuildNumber() {
        return this.buildInfo.get("BUILDNUMBER");
    }

    public void setCkPowerCycleModem(boolean setting) {
        this.ckPowerCycleModem = setting;
    }
}

