/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.LoggerUtils;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BootieUtilities {
    private final INovacomDevice device;
    private static final String TELLBOOTIE = "/sbin/tellbootie";
    private static final Logger logger = LoggerUtils.getInstance().getLogger("BootieUtilites");
    static final String PERCENTAGE = "percentage: ";
    static final String DMMODEL = "DMMODEL";

    public BootieUtilities(INovacomDevice device) throws NovacomException, IOException {
        this(device, false);
    }

    public BootieUtilities(INovacomDevice device, boolean doForceIntoBootieMode) throws NovacomException, IOException {
        if (null == device) {
            throw new NovacomException(-1, 20, "Device Not Passed In");
        }
        this.device = device;
        if (Novacom.DeviceState.BOOTLOADER != device.getState() && doForceIntoBootieMode) {
            try {
                INovacomStream stream = device.runProgram(TELLBOOTIE, new String[]{"recover"});
                while (stream.read() > 0) {
                    System.out.println("waiting to reboot...");
                }
                stream.close();
            }
            catch (NovacomException e) {
                logger.log(Level.WARNING, "Rebooting device", e);
            }
            device.waitForDeviceToAppear();
        }
        this.checkThatWeAreInBootieMode();
    }

    private void checkThatWeAreInBootieMode() throws NovacomException, IOException {
        if (Novacom.DeviceState.BOOTLOADER != this.device.getState()) {
            System.err.println("Device must be in bootloader mode.");
            System.err.println("Please restart your device while holding down the 'x' key");
            System.err.println("or volume-up button.");
            System.err.println("When the USB logo appears, plug-in the USB cable and re-run this program.");
            throw new NovacomException(-1, 21, "Not in Bootie Mode");
        }
    }

    public String readCciAuxSerialNumber() throws IOException, NovacomException {
        INovacomStream stream = this.device.runProgram("", null);
        String command = "auxsn read";
        byte[] bytes = command.getBytes("US-ASCII");
        stream.write(bytes);
        stream.closeOutput();
        String reply = stream.readLine();
        System.err.print(reply);
        stream.close();
        return reply;
    }

    public String writeCciAuxSerialNumber(String serialNumber) throws NovacomException, IOException {
        INovacomStream stream = this.device.runProgram("", null);
        String command = "auxsn write " + serialNumber;
        byte[] bytes = command.getBytes("US-ASCII");
        stream.write(bytes);
        stream.closeOutput();
        String reply = stream.readLine();
        System.err.print(reply);
        stream.close();
        return reply;
    }

    public String readRadioSerialNumber() throws NovacomException, IOException {
        INovacomStream stream = this.device.runProgram("", null);
        String command = "pcomm serial get";
        byte[] bytes = command.getBytes("US-ASCII");
        stream.write(bytes);
        stream.closeOutput();
        String reply = stream.readLine();
        System.err.print(reply);
        stream.close();
        return reply;
    }

    public Integer checkPowerStatus() throws NovacomException, IOException {
        String temp;
        INovacomStream stream = this.device.runProgram("", null);
        String command = "battery status";
        byte[] bytes = command.getBytes("US-ASCII");
        stream.write(bytes);
        stream.closeOutput();
        String reply = "";
        while ((temp = stream.readLine()) != null && temp.length() > 1) {
            if (!temp.startsWith(PERCENTAGE)) continue;
            reply = temp.substring(PERCENTAGE.length(), temp.indexOf("\n"));
        }
        logger.fine("Battery: " + reply);
        if (reply == null || reply.length() == 0) {
            return -1;
        }
        Integer percentage = new Integer(reply);
        stream.close();
        return percentage;
    }

    public String getDMModel() throws NovacomException, IOException {
        String temp;
        INovacomStream stream = this.device.runProgram("", null);
        String command = "token dump";
        byte[] bytes = command.getBytes("US-ASCII");
        stream.write(bytes);
        stream.closeOutput();
        String dmModel = "";
        while ((temp = stream.readLine()) != null && temp.length() > 1) {
            if (!temp.contains(DMMODEL)) continue;
            String[] tokens = temp.split(" ");
            dmModel = tokens[9].replaceAll("'", "").replaceAll("\\n", "");
            break;
        }
        logger.fine("DMMODEL: " + dmModel);
        if (dmModel == null || dmModel.length() == 0) {
            logger.warning("No valid DMMODEL defined");
        }
        stream.close();
        return dmModel;
    }
}

