/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class InstallerModel {
    Document document;

    public void parseInstallerDocument() throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(this.getInputStream("installer.xml"));
        }
        catch (Exception e) {
            IOException e2 = new IOException("Installer.xml cannot be parsed! There may be a problem with the base ROM and or Customization package you have chosen." + e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
    }

    protected abstract InputStream lookForInputStream(String var1) throws IOException;

    public InputStream getInputStream(String filename) throws IOException {
        InputStream in = this.lookForInputStream(filename);
        if (in == null) {
            in = new FileInputStream(filename);
        }
        return in;
    }

    abstract long lookForFileSize(String var1) throws IOException;

    public long getFileSize(String filename) throws IOException {
        long size = this.lookForFileSize(filename);
        if (size == -1L) {
            File file = new File(filename);
            size = file.length();
        }
        return size;
    }

    public String getTarget() {
        return this.document.getDocumentElement().getAttribute("target");
    }

    public String getImage() {
        return this.document.getDocumentElement().getAttribute("image");
    }

    public String getVersion() {
        return this.document.getDocumentElement().getAttribute("version");
    }

    public String getRamDisk() {
        return this.document.getDocumentElement().getAttribute("ramdisk");
    }

    public String getBootFile() {
        return this.document.getDocumentElement().getAttribute("bootfile");
    }

    public String getName() {
        return this.document.getDocumentElement().getAttribute("name");
    }

    public String getDestination() {
        return this.document.getDocumentElement().getAttribute("destination");
    }

    public String getDMSetToken() throws FileNotFoundException {
        NodeList list = this.document.getElementsByTagName("DMSet");
        Element element = (Element)list.item(0);
        if (element == null) {
            throw new FileNotFoundException("No DMSet tokens found in installer.xml.");
        }
        return element.getAttribute("token");
    }

    public String getBatteryCheckToken() throws FileNotFoundException {
        NodeList list = this.document.getElementsByTagName("BatteryCheck");
        Element element = (Element)list.item(0);
        if (element == null) {
            throw new FileNotFoundException("No BatteryCheck tokens found in installer.xml.");
        }
        return element.getAttribute("token");
    }

    public String getRamDiskFilename() {
        return this.generateImageName(this.getRamDisk(), "uImage");
    }

    public long getRootFilesystemMinSize() throws IOException {
        String rootFileSystemMinSize = "";
        NodeList list = this.document.getElementsByTagName("RootFilesystem");
        Element element = (Element)list.item(0);
        if (element != null) {
            rootFileSystemMinSize = element.getAttribute("min");
            if (rootFileSystemMinSize == "") {
                throw new IOException("RootFilesystem \"min\" attribute was not found or it was empty in xml document.");
            }
            return Long.valueOf(rootFileSystemMinSize);
        }
        throw new IOException("\"RootFilesystem\" element not found in xml document.");
    }

    private String generateImageName(String prefix, String postfix) {
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append("-");
        buffer.append(this.getTarget());
        buffer.append(".");
        buffer.append(postfix);
        return buffer.toString();
    }

    public InputStream getImageFileStream() throws IOException {
        return this.getInputStream(this.generateImageName(this.getImage(), "rootfs.tar.gz"));
    }

    public InputStream getRamDiskFileStream() throws IOException {
        return this.getInputStream(this.getRamDiskFilename());
    }

    public String getModemUpdaterFileName(String type) throws FileNotFoundException {
        NodeList list = this.document.getElementsByTagName("ModemUpdater");
        Element element = (Element)list.item(0);
        if (element == null) {
            throw new FileNotFoundException("No modem firmware entry in model.");
        }
        String name = element.getAttribute(type.toLowerCase());
        if (name.compareTo("") == 0) {
            return null;
        }
        return name;
    }

    public InputStream getModemUpdaterFileStream(String type) throws IOException {
        String name = this.getModemUpdaterFileName(type);
        return name == null ? null : this.getInputStream(name);
    }
}

