/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.recoverytool;

import com.palm.nova.installer.core.LoggerUtils;
import com.palm.nova.installer.recoverytool.CardController;
import com.palm.nova.installer.recoverytool.CmdLineInterface;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.SwingUtilities;

public class RecoveryTool {
    public static final String LOGGER = "com.palm.recoverytool";
    public static final String LOGGER_FILE_NAME = "PalmWebOsRecoveryToolLog";
    static CardController cardController;

    private static void initLogger() {
        Logger logger = Logger.getLogger(LOGGER);
        LoggerUtils.getInstance().setGlobalLogger(logger);
        try {
            FileHandler handler = new FileHandler("%t/PalmWebOsRecoveryToolLog%u.log", 200000, 3, true);
            SimpleFormatter simpleFormatter = new SimpleFormatter();
            handler.setFormatter(simpleFormatter);
            logger.addHandler(handler);
        }
        catch (SecurityException e) {
            logger.log(Level.WARNING, "Couldn't Add Logging Handle", e);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Couldn't Add Logging Handle", e);
        }
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            CmdLineInterface.cmdLineMain(args);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RecoveryTool.initLogger();
                    cardController = new CardController();
                }
            });
        }
    }
}

