/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.LoggerUtils;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.util.logging.Level;

public class GoIntoUpdateModeStage
extends BaseStage
implements IInstallerStage {
    private static final String TELLBOOTIE = "/sbin/tellbootie";
    private final INovacomDevice device;

    public GoIntoUpdateModeStage(INovacomDevice device) {
        this.device = device;
    }

    @Override
    public String toString() {
        return "Go Into Update Mode";
    }

    @Override
    public void run() throws IOException, NovacomException {
        IStageProgressReporter progress = this.getProgressHandler();
        Object jid = progress.startJob("Getting Into Update Mode", 1);
        if (this.device.getState() == Novacom.DeviceState.BOOTLOADER) {
            progress.commentOnJob(jid, "Already in bootloader, update can continue");
        } else {
            progress.commentOnJob(jid, "Rebooting into update mode");
            try {
                INovacomStream stream = this.device.runProgram(TELLBOOTIE, new String[]{"recover"});
                stream.close();
            }
            catch (NovacomException e) {
                LoggerUtils.getInstance().getLogger("GoIntoUpdateModeStage").log(Level.WARNING, "rebooting probably caused this exception", e);
            }
            progress.commentOnJob(jid, "Waiting for device to come back");
            this.device.waitForDeviceToAppear();
        }
        progress.commentOnJob(jid, "Finished");
        progress.endJob(jid);
    }
}

