/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.MountUtils;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class SaveLogsBeforeFlashStage
extends BaseStage {
    private static final String RUNNER_NAME = "SaveLogsBeforeFlash";
    private static final String RM = "/bin/rm";
    private static final String MKDIR = "/bin/mkdir";
    private static final String TEMP_MEDIAFS = "/tmp_media";
    private static final String TEMP_LOG = "/tmp_log";
    private static final String TEMP_VAR = "/tmp_var";
    private static final String COLLECT_LOGS = "/usr/local/sbin/recovery/save_logs.sh";
    private final INovacomDevice device;
    private Object jobId;
    private static final boolean saveLog = true;

    public SaveLogsBeforeFlashStage(INovacomDevice device) {
        this.device = device;
    }

    @Override
    public void run() throws IOException, NovacomException {
        IStageProgressReporter reporter = this.getProgressHandler();
        this.jobId = reporter.startJob(RUNNER_NAME, 100);
        reporter.commentOnJob(this.jobId, "saving logs before flashing ");
        this.runCommand(RM, new String[]{"-rf", TEMP_MEDIAFS});
        this.runCommand(MKDIR, new String[]{"-p", TEMP_MEDIAFS});
        this.runCommand(RM, new String[]{"-rf", TEMP_LOG});
        this.runCommand(MKDIR, new String[]{"-p", TEMP_LOG});
        MountUtils mountUtils = new MountUtils(this.device);
        mountUtils.mount(MountUtils.MountParts.MEDIAFS, MountUtils.FsType.VFAT, TEMP_MEDIAFS);
        mountUtils.mount(MountUtils.MountParts.LOGFS, MountUtils.FsType.EXT3, TEMP_LOG);
        reporter.commentOnJob(this.jobId, "mounted mediafs and logfs sucessfully");
        INovacomStream stream = this.device.runProgram(COLLECT_LOGS, new String[0]);
        stream.flush();
        String line = stream.readLine();
        while (line.compareTo("") != 0) {
            reporter.commentOnJob(this.jobId, line);
            line = stream.readLine();
        }
        stream.flush();
        int retCode = stream.waitForReturnCode();
        if (retCode != 0) {
            reporter.commentOnJob(this.jobId, "WARNING:: Issue with saving logs");
        }
        stream.close();
        reporter.commentOnJob(this.jobId, "Done with SaveLog stage");
        mountUtils.umount(MountUtils.MountParts.MEDIAFS);
        mountUtils.umount(MountUtils.MountParts.LOGFS);
        reporter.endJob(this.jobId);
    }

    private void runCommand(String command, String[] args) throws IOException, NovacomException {
        if (args == null) {
            args = new String[]{};
        }
        INovacomStream stream = this.device.runProgram(command, args);
        stream.flush();
        this.printStreamToProgressReporter(stream, true);
    }

    private void printStreamToProgressReporter(INovacomStream stream, Boolean closeStream) throws IOException, NovacomException {
        String line = stream.readLine();
        while (line.compareTo("") != 0) {
            this.getProgressHandler().commentOnJob(this.jobId, line);
            line = stream.readLine();
        }
        if (closeStream.booleanValue()) {
            stream.flush();
            stream.close();
        }
    }

    @Override
    public String toString() {
        return RUNNER_NAME;
    }
}

