/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.StringUtilities;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;

public class ModemUtilities {
    private final INovacomDevice device;
    private final HashMap<String, String> modemInfo;

    private void gatherResults(INovacomStream stream, HashMap<String, String> map) throws IOException, NovacomException {
        String line = stream.readLine();
        while (line.length() > 0) {
            if (line.charAt(0) == '$') {
                if (line.indexOf(61) > 0) {
                    String[] pairs = line.substring(1).split("=");
                    map.put(StringUtilities.trim(pairs[0]), StringUtilities.trim(pairs[1]));
                } else {
                    String name = line.substring(1);
                    map.put(StringUtilities.trim(name), "");
                }
            }
            line = stream.readLine();
        }
    }

    public ModemUtilities(INovacomDevice device) throws IOException, NovacomException {
        this.device = device;
        this.modemInfo = new HashMap();
        this.modemInfo.put("FW VERSION", "N/A");
        this.modemInfo.put("MODEM MODEL", "N/A");
        this.modemInfo.put("IMEI", "N/A");
        INovacomStream power = device.runProgram("/usr/bin/pmmodempower", new String[]{"cycle"});
        power.close();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        INovacomStream output = device.runProgram("/usr/bin/PmModemInfo", new String[]{"-e"});
        this.gatherResults(output, this.modemInfo);
        output.close();
    }

    public String getModemFirmwareVersion() {
        return this.modemInfo.get("FW VERSION");
    }

    public String getModemType() {
        return this.modemInfo.get("MODEM MODEL");
    }

    public String getModemID() {
        if (this.getModemType().compareTo("CDMA") == 0 || this.getModemType().compareTo("WORLD") == 0) {
            return this.modemInfo.get("MEID");
        }
        return this.modemInfo.get("IMEI");
    }

    public boolean sendBackupFactoryNvItemsCmd() throws NovacomException, IOException {
        String[] args = new String[]{"-j", "0"};
        INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        String nvdata = map.get("FACTORY-NV BACKUP SUCCESS!");
        output.close();
        return null != nvdata;
    }

    public boolean enableSimLock(String code) throws NovacomException, IOException {
        String[] args = new String[]{"-s", code};
        INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        String nvdata = map.get("SIM LOCK");
        output.close();
        return nvdata.equalsIgnoreCase("SET SUCCESS!");
    }

    public boolean disableSimLock(String code) throws NovacomException, IOException {
        String[] args = new String[]{"-b", code};
        INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        String nvdata = map.get("SIM UNLOCK");
        output.close();
        return nvdata.equalsIgnoreCase("SET SUCCESS!");
    }

    public boolean simLockDataWrite(String data) throws NovacomException, IOException {
        String[] args = new String[]{"-d", data};
        INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        String nvdata = map.get("SIM DATA");
        output.close();
        return nvdata.equalsIgnoreCase("SET SUCCESS!");
    }

    public boolean simLockKeyWrite(String key) throws NovacomException, IOException {
        String[] args = new String[]{"-k", key};
        INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        String nvdata = map.get("SIM KEY");
        output.close();
        return nvdata.equalsIgnoreCase("SET SUCCESS!");
    }

    public boolean getSimLockStatus() throws NovacomException, IOException {
        String[] args = new String[]{"-x"};
        INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        String nvdata = map.get("SIM LOCK");
        output.close();
        return nvdata.equalsIgnoreCase("ACTIVATED!");
    }

    public byte[] getNVItem(int item, int slotNumber) throws IOException, NovacomException {
        String[] numbers;
        byte[] results = new byte[]{};
        String[] args = new String[]{"-n", "read", Integer.toString(item), Integer.toString(slotNumber)};
        INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        String nvdata = map.get("NV DATA");
        if (nvdata != null && (numbers = nvdata.split("  ")).length > 0) {
            results = new byte[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                if (numbers[i].length() > 2) {
                    numbers[i] = numbers[i].substring(2);
                }
                results[i] = (byte)(Integer.parseInt(numbers[i].toLowerCase(), 16) & 0xFF);
            }
        }
        output.close();
        return results;
    }

    public byte[] setNVItem(int item, byte[] values) throws IOException, NovacomException {
        String[] numbers;
        byte[] results = new byte[]{};
        StringBuffer script = new StringBuffer("#!/bin/sh\n/usr/bin/PmModemFactory -n write ");
        script.append(item);
        script.append(" ");
        for (int i = 0; i < values.length; ++i) {
            script.append(values[i] & 0xFF);
            script.append(" ");
        }
        script.append("\nexit 0");
        INovacomStream output = this.device.putFile("/tmp/nvscript.sh");
        output.write(script.toString().getBytes("US-ASCII"));
        output.closeInput();
        output.closeOutput();
        output.waitForReturnCode();
        output.close();
        output = this.device.runProgram("/bin/sh", new String[]{"-c", "/tmp/nvscript.sh"});
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        if (null == map.get("NV WRITE SUCCESS!")) {
            throw new NovacomException(-1, "Error Writing NV Items: Success Message Not Found");
        }
        String nvdata = map.get("NV DATA");
        if (nvdata != null && (numbers = nvdata.split("  ")).length > 0) {
            results = new byte[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                if (numbers[i].length() > 2) {
                    numbers[i] = numbers[i].substring(2);
                }
                results[i] = (byte)(Integer.parseInt(numbers[i].toLowerCase(), 16) & 0xFF);
            }
        }
        output.close();
        return results;
    }

    public int setNVItemFromIcss(int item, byte[] values) throws IOException, NovacomException {
        int retVal = 1;
        try {
            this.setNVItem(item, values);
        }
        catch (NovacomException e) {
            if (e.getErrorMessage().equals("Error Writing NV Items: Success Message Not Found")) {
                retVal = 0;
            }
            throw e;
        }
        return retVal;
    }

    public byte[] getNVItem(int item) throws IOException, NovacomException {
        String[] numbers;
        byte[] results = new byte[]{};
        String[] args = new String[]{"-n", "read", Integer.toString(item)};
        INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        String nvdata = map.get("NV DATA");
        output.close();
        if (nvdata != null && (numbers = nvdata.split("  ")).length > 0) {
            results = new byte[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                if (numbers[i].length() > 2) {
                    numbers[i] = numbers[i].substring(2);
                }
                results[i] = (byte)(Integer.parseInt(numbers[i].toLowerCase(), 16) & 0xFF);
            }
        }
        return results;
    }

    public int sendMSL(String msl) throws IOException, NovacomException {
        String[] args = new String[]{"-p", msl};
        INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        String nvdata = map.get("MODEM UNLOCK SUCCESS");
        if (nvdata == null) {
            return 0;
        }
        return 1;
    }

    public int rtnReset() throws IOException, NovacomException {
        String[] args = new String[]{"-r 0"};
        INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        String nvdata = map.get("RTN SET SUCCESS!");
        if (nvdata == null) {
            return 0;
        }
        return 1;
    }

    public String priReset() throws NovacomException, IOException {
        try {
            String[] args = new String[]{"-c pri/CUST.PRI"};
            INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
            HashMap<String, String> map = new HashMap<String, String>();
            this.gatherResults(output, map);
            byte[] bytes = new byte[]{0, 0};
            this.setNVItem(9001, bytes);
            this.modemPowerCycle();
            System.err.println("Power cycle done.");
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            return new String("priReset FAILED");
        }
        return this.getPriCRC();
    }

    public boolean modemPowerCycle() throws NovacomException, IOException {
        try {
            String[] args = new String[]{"cycle"};
            INovacomStream stream = this.device.runProgram("/usr/bin/pmmodempower", args);
            stream.close();
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getPriCRC() throws NovacomException, IOException {
        String[] args = new String[]{"-i"};
        INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        String nvdata = map.get("PRI CRC");
        if (nvdata == null) {
            return "N/A";
        }
        return nvdata;
    }

    public String getPrlRevision() throws NovacomException, IOException {
        String[] args = new String[]{"-l"};
        INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        String nvdata = map.get("PRL VERSION");
        if (nvdata == null) {
            return "N/A";
        }
        return nvdata;
    }

    private boolean setEfsFile(String deviceFolder, String hostPath) throws NovacomException, IOException {
        File localfile = new File(hostPath);
        String devicePath = deviceFolder + "/" + localfile.getName();
        INovacomStream stream = this.device.putFile("/tmp/" + localfile.getName());
        stream.write(new FileInputStream(localfile));
        stream.close();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        StringBuffer buffer = new StringBuffer("#!/bin/sh\n");
        buffer.append("/usr/bin/PmModemFactory -u ");
        buffer.append(devicePath);
        buffer.append(" < /tmp/");
        buffer.append(localfile.getName());
        buffer.append("\n");
        stream = this.device.putFile("/tmp/efs.sh");
        stream.write(buffer.toString().getBytes());
        stream.close();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        String[] args = new String[]{"-e", "/tmp/efs.sh"};
        INovacomStream efs = this.device.runProgram("/bin/sh", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(efs, map);
        efs.close();
        String result = map.get("EFS WRITE");
        return result != null && result.compareTo("SUCCESS!") == 0;
    }

    public boolean setPrlFile(String prlPath) throws NovacomException, IOException {
        return this.setEfsFile("prl", prlPath);
    }

    public boolean setPriFile(String priPath) throws NovacomException, IOException {
        return this.setEfsFile("pri", priPath);
    }

    public boolean setModemImeiOrMeid(String modemId) throws NovacomException, IOException {
        StringBuffer script = new StringBuffer("#!/bin/sh\n/usr/bin/PmModemFactory -f ");
        script.append(modemId.toUpperCase());
        script.append("\nexit 0");
        INovacomStream output = this.device.putFile("/tmp/setmodemidscript.sh");
        output.write(script.toString().getBytes("US-ASCII"));
        output.closeInput();
        output.closeOutput();
        output.waitForReturnCode();
        output.close();
        output = this.device.runProgram("/bin/sh", new String[]{"-c", "/tmp/setmodemidscript.sh"});
        output.waitForReturnCode();
        output.close();
        return true;
    }

    public boolean setModemMode(ModemMode mode) throws NovacomException, IOException {
        String modeString = "0";
        switch (mode) {
            case ONLINE: {
                modeString = "4";
                break;
            }
            case OFFLINE: {
                modeString = "1";
                break;
            }
            case RESET: {
                modeString = "2";
            }
        }
        String[] args = new String[]{"-o", modeString};
        INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        String nvdata = map.get("MODEM MODE SET SUCCESS");
        return nvdata != null;
    }

    public boolean resetModem(boolean doFactoryReset) throws NovacomException, IOException {
        boolean didWork = false;
        String[] args = new String[]{"-r", doFactoryReset ? "0" : "1"};
        INovacomStream output = this.device.runProgram("/usr/bin/PmModemFactory", args);
        HashMap<String, String> map = new HashMap<String, String>();
        this.gatherResults(output, map);
        if (null != map.get("RTN SET SUCCESS!")) {
            didWork = true;
        }
        output.close();
        return didWork;
    }

    public static enum ModemMode {
        ONLINE,
        OFFLINE,
        RESET;

    }
}

