/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.recoverytool.cards;

import com.palm.nova.installer.recoverytool.CardController;
import com.palm.nova.installer.recoverytool.cards.CardBase;
import com.palm.nova.installer.recoverytool.cards.Messages;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class LanguagePickerCard
extends CardBase {
    private static final long serialVersionUID = -5867623326345888337L;
    JComboBox langPicker;
    Properties langPickerProps = null;

    public LanguagePickerCard(CardController cardController) {
        super(cardController);
        this.setBoxAligmnet(0.5f);
        this.initSecondButton(Messages.getString("CardBase.1"), false);
        this.addFiller();
        this.addIcon("/resources/languages.png");
        this.addFiller();
        this.langPickerProps = new Properties();
        try {
            InputStream langPickerPropsFile = this.getClass().getResourceAsStream("/resources/languagePicker.properties");
            if (langPickerPropsFile != null) {
                this.langPickerProps.load(langPickerPropsFile);
            } else {
                this.langPickerProps.setProperty("Default", "English");
                this.langPickerProps.setProperty("Espa\u00f1ol", "es_US");
                this.langPickerProps.setProperty("English", "en_US");
            }
        }
        catch (IOException e) {
            this.langPickerProps.setProperty("Default", "English");
            this.langPickerProps.setProperty("Espa\u00f1ol", "es_US");
            this.langPickerProps.setProperty("English", "en_US");
        }
        String defaultLanguage = this.langPickerProps.getProperty("Default");
        if (defaultLanguage != null) {
            this.langPickerProps.remove("Default");
        } else {
            defaultLanguage = "English";
        }
        TreeSet<Object> keySet = new TreeSet<Object>(this.langPickerProps.keySet());
        String[] languages = new String[keySet.size()];
        languages = keySet.toArray(languages);
        this.langPicker = new JComboBox<String>(new DefaultComboBoxModel<String>(languages));
        this.langPicker.setSelectedItem(defaultLanguage);
        this.langPicker.setMaximumSize(new Dimension(300, 20));
        this.langPicker.setAlignmentY(0.5f);
        this.langPicker.setAlignmentX(0.5f);
        this.langPicker.setActionCommand("langPicker");
        this.langPicker.addActionListener(cardController);
        this.add(this.langPicker);
    }

    public int getLanguage() {
        return this.langPicker.getSelectedIndex();
    }

    @Override
    public Locale getLocale() {
        if (this.langPickerProps == null) {
            return Locale.ENGLISH;
        }
        String language = (String)this.langPicker.getSelectedItem();
        String localeString = this.langPickerProps.getProperty(language);
        String[] parts = localeString.split("_");
        Locale locale = parts.length == 3 ? new Locale(parts[0], parts[1], parts[2]) : (parts.length == 2 ? new Locale(parts[0], parts[1]) : (parts.length == 1 ? new Locale(parts[0]) : Locale.ENGLISH));
        return locale;
    }

    public void resetFlowButton() {
        this.initFlowButton(Messages.getString("CardBase.0"), true, true);
    }
}

