/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class A6UpdateStage
extends BaseStage
implements IInstallerStage {
    private static final String UPDATE_CMD = "/usr/bin/PmA6Updater";
    private static final String UPDATE_FILE = "/lib/firmware/a6_firmware.txt";
    private static final String RUNNER_NAME = "A6 Updater";
    private final INovacomDevice device;
    private Object jobId;
    private boolean forceUpdate = true;

    public A6UpdateStage(INovacomDevice device) {
        this.device = device;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    @Override
    public String toString() {
        return RUNNER_NAME;
    }

    @Override
    public void run() throws IOException, NovacomException {
        IStageProgressReporter reporter = this.getProgressHandler();
        this.jobId = reporter.startJob(RUNNER_NAME, 100);
        String machineType = this.device.getDeviceInfo().getMachineName();
        if (!(machineType.contentEquals("broadway") || machineType.contentEquals("windsor") || machineType.contentEquals("mantaray"))) {
            reporter.commentOnJob(this.jobId, "Not updating A6 firmware: no A6 on the device");
            reporter.endJob(this.jobId);
            return;
        }
        reporter.commentOnJob(this.jobId, "Starting the A6 stage");
        if (this.forceUpdate) {
            INovacomStream stream = this.device.runProgram(UPDATE_CMD, new String[]{UPDATE_FILE});
            stream.flush();
            String line = stream.readLine();
            while (line.compareTo("") != 0) {
                reporter.commentOnJob(this.jobId, line);
                line = stream.readLine();
            }
            stream.flush();
            stream.close();
            reporter.commentOnJob(this.jobId, "Done with A6 stage");
        } else {
            reporter.commentOnJob(this.jobId, "Skip the A6 stage");
        }
        reporter.endJob(this.jobId);
    }
}

