/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.IFlasherLogger;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.InstallerModel;
import com.palm.nova.installer.core.ResourceInTarInstallerModel;
import com.palm.nova.installer.core.ScreenPainter;
import com.palm.nova.installer.core.TarredInstallerModel;
import com.palm.nova.installer.core.TrenchcoatModel;
import com.palm.nova.installer.core.UpgradePopupWindow;
import com.palm.nova.installer.core.stages.A6UpdateStage;
import com.palm.nova.installer.core.stages.AppFolderDeletionStage;
import com.palm.nova.installer.core.stages.BypassFirstUseStage;
import com.palm.nova.installer.core.stages.ChargeBatteryStage;
import com.palm.nova.installer.core.stages.CustomizationStage;
import com.palm.nova.installer.core.stages.DataPreCheckStage;
import com.palm.nova.installer.core.stages.DataRestoreStage;
import com.palm.nova.installer.core.stages.DataSaveStage;
import com.palm.nova.installer.core.stages.EnableNovacomUsbByDefaultStage;
import com.palm.nova.installer.core.stages.GoIntoUpdateModeStage;
import com.palm.nova.installer.core.stages.ModemUpdateStage;
import com.palm.nova.installer.core.stages.RamdiskLoadingStage;
import com.palm.nova.installer.core.stages.RestoreLogsAfterFlashStage;
import com.palm.nova.installer.core.stages.SaveLogsBeforeFlashStage;
import com.palm.nova.installer.core.stages.SideloadStage;
import com.palm.nova.installer.core.stages.SoftwareUpdateSiteStage;
import com.palm.nova.installer.core.stages.TouchPanelUpdateStage;
import com.palm.nova.installer.core.stages.TrenchcoatStage;
import com.palm.nova.installer.core.stages.VerifyRomStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

public class FlasherThread
implements Runnable,
IStageProgressReporter {
    InstallerModel baseModel = null;
    TarredInstallerModel customizationModel = null;
    ResourceInTarInstallerModel sideloadModel = null;
    InstallerModel prevBaseModel = null;
    TarredInstallerModel prevCustomizationModel = null;
    String massStorageData = null;
    String softwareUpdateSiteFile = null;
    String softwareUpdateSiteUrl = null;
    String softwareUpdateSiteLabel = null;
    boolean softwareUpdateSiteSupported = true;
    String postFlashScript = null;
    INovacomDevice device;
    IFlasherLogger flasherLogger;
    UpgradePopupWindow popUp;
    String developerMode = "";
    boolean doVerifyRomImage = true;
    boolean doForceModemFwUpdate = false;
    boolean checkCloudApi = false;
    private boolean doSaveMsm = false;
    private boolean runDataRestoreStage = false;
    private boolean loadRamdisk = true;
    int percentFlashedComplete = 0;
    private String screenPicture = "";
    private boolean doSkipBatteryCeck = false;
    private boolean doSkipFirstUse = false;
    private boolean doSkipModemFwUpdate = false;
    private boolean doSkipTouchpanelUpdate = false;
    private boolean doForceTouchpanelUpdate = false;
    private boolean doVerifyRfsSize = false;
    private String carrierList = "";
    private String modelList = "";
    private String deviceType = "";
    private String buildNumber = "";
    private String domName = "";
    private String prodFile = "";
    private boolean checkToFlash = false;
    private boolean doDeleteAppDirectory = true;
    private boolean saveLogsBeforeFlash = false;
    private boolean restoreLogsAfterFlash = false;
    private boolean runDataMigrationStages = false;
    private int resizeRootFS = 0;
    private String upgradeRestoreChoice = "";
    private boolean preCheckValue = false;
    private boolean dataSaveValue = false;
    private boolean enableCmdLineMode = false;
    private boolean goBackFlag = false;
    static final int INIT = 1;
    static final int UPDATE_STAGE = 2;
    static final int RAMDISK_LOADING_STAGE = 7;
    static final int PAINT_IMAGE = 1;
    static final int BUILD_TRENCOAT_MODEL = 3;
    static final int TRENCHCOAT_STAGE = 40;
    static final int CUSTOMIZATION_STAGE = 10;
    static final int SOFTWARE_UPDATE_STAGE = 5;
    static final int VERIFY_ROM_STAGE = 5;
    static final int MODEM_STAGE = 20;
    static final int TOUCHPANEL_STAGE = 6;
    static final String CARRIER = "DMCARRIER";
    static final String MODEL = "DMMODEL";
    static final String PROD_ID = "PRODoID";
    static final int NUM_RETRIES = 2;
    static final String prodName = "ps";

    public FlasherThread(InstallerModel baseModel, TarredInstallerModel customizationModel) {
        this.baseModel = baseModel;
        this.customizationModel = customizationModel;
    }

    @Override
    public void run() {
        int retries = 2;
        try {
            String machineType;
            Novacom.DeviceState state = this.device.getState();
            while (retries > 0) {
                this.percentFlashedComplete = 0;
                ++this.percentFlashedComplete;
                this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.PERCENT_UPDATE, this.percentFlashedComplete);
                if (this.checkToFlash) {
                    String msg;
                    String nduid = this.device.getDeviceInfo().getUIDString().toLowerCase();
                    String DMSetOne = this.baseModel.getDMSetToken();
                    String DMSetTwo = this.customizationModel.getDMSetToken();
                    this.flasherLogger.logPrintln("**device NDU-ID is: " + nduid);
                    this.flasherLogger.logPrintln("**WODbuild DMSet tokens are: " + DMSetOne + " and " + DMSetTwo);
                    this.flasherLogger.logPrintln("**WODbuildNumber is: " + this.buildNumber);
                    if (nduid.length() == 0 || DMSetOne.length() == 0 || DMSetTwo.length() == 0 || this.buildNumber.length() == 0) {
                        this.flasherLogger.logPrintln("Missing or empty input parameters, will not able to verify build with CS");
                        throw new NovacomException(-1, "UNAUTHORIZED BUILD: This WOS build is not authorized to flash this device. Exiting!!");
                    }
                    StringBuilder sb = new StringBuilder("https://");
                    if (this.domName == null || this.domName.length() == 0 && this.prodFile != null) {
                        sb.append(this.prodFile);
                    } else if (this.prodFile == null && this.domName.length() > 0) {
                        String newName = this.domName.replace("lcn", prodName);
                        sb.append(newName);
                        sb.append(".palm.com");
                    }
                    sb.append("/palmcsext/verifyWOD?nduId=" + nduid);
                    sb.append("&dmset1=" + DMSetOne);
                    sb.append("&dmset2=" + DMSetTwo);
                    sb.append("&build=" + this.buildNumber);
                    this.flasherLogger.logPrintln("URL :" + sb.toString());
                    try {
                        URL url = new URL(sb.toString());
                        HttpURLConnection huc = (HttpURLConnection)url.openConnection();
                        huc.setRequestMethod("GET");
                        huc.setDoOutput(true);
                        huc.setReadTimeout(6000);
                        huc.connect();
                        int code = huc.getResponseCode();
                        if (code == 200) {
                            this.flasherLogger.logPrintln("Current build is authorized to flash this device. Continue flashing!");
                        } else {
                            String errorText = "UNAUTHORIZED BUILD: This WOS build is not authorized to flash this device. Exiting with error code: " + code;
                            if (this.checkCloudApi) {
                                throw new NovacomException(-1, errorText);
                            }
                            this.flasherLogger.logPrintln(errorText);
                        }
                        huc.disconnect();
                    }
                    catch (ProtocolException e) {
                        msg = "UNAUTHORIZED BUILD: This WOS build had an ProtocolException trying to authenticate with foll msg: " + e.getMessage();
                        throw new NovacomException(-1, msg);
                    }
                    catch (MalformedURLException e) {
                        msg = "UNAUTHORIZED BUILD: This WOS build had an MalformedURLException trying to authenticate with foll msg: " + e.getMessage();
                        throw new NovacomException(-1, msg);
                    }
                    catch (IOException e) {
                        msg = "UNAUTHORIZED BUILD: This WOS build had an IOException trying to authenticate with foll msg: " + e.getMessage();
                        throw new NovacomException(-1, msg);
                    }
                }
                if (state == Novacom.DeviceState.OS || state == Novacom.DeviceState.INSTALLER && this.loadRamdisk) {
                    this.flasherLogger.logPrintln("device believed to be in the device OS or ramdisk, will try to force to bootie");
                    GoIntoUpdateModeStage intoUpdateMode = new GoIntoUpdateModeStage(this.device);
                    intoUpdateMode.setProgressHandler(this);
                    intoUpdateMode.run();
                    state = this.device.getState();
                }
                if (state == Novacom.DeviceState.BOOTLOADER) {
                    if (!this.doSkipBatteryCeck) {
                        ChargeBatteryStage chargeBatteryStage = new ChargeBatteryStage(this.device);
                        chargeBatteryStage.setProgressHandler(this);
                        chargeBatteryStage.run();
                    }
                    if (retries == 2) {
                        String macName = this.device.getDeviceInfo().getMachineName().toLowerCase();
                        if (this.deviceType.length() == 0) {
                            this.flasherLogger.logPrintln("WARNING - DeviceType returned is empty, unless not checking for DeviceType in the case of NDI");
                        } else if (this.deviceType.contains(macName)) {
                            this.flasherLogger.logPrintln("Found DeviceType match for : " + macName);
                        } else if (this.deviceType.length() > 0 && !this.deviceType.contains(macName)) {
                            this.flasherLogger.logPrintln("DeviceType on the webOS Dr is : " + this.deviceType + " and deviceType on the device is : " + macName);
                            this.resetDevice();
                            throw new NovacomException(-1, "TOKEN MISMATCH: Failed to find match for Device information. Prevent user from flashing");
                        }
                    }
                    this.flasherLogger.logPrintln("device believed to be in bootloader, will load ramdisk");
                    RamdiskLoadingStage ramdiskStage = new RamdiskLoadingStage(this.baseModel, this.device);
                    ramdiskStage.setProgressHandler(this);
                    ramdiskStage.run();
                    state = this.device.getState();
                }
                --retries;
                if (state != Novacom.DeviceState.INSTALLER) {
                    this.flasherLogger.logPrintln("device not in ramdisk, state is " + (Object)((Object)state));
                    if (retries == 0) {
                        this.flasherLogger.logPrintln("can't get into update state, retries exhausted");
                        throw new NovacomException(-1, "the device isn't running the ramdisk as expected");
                    }
                    this.flasherLogger.logPrintln("trying to get into update state again");
                    continue;
                }
                retries = 0;
                this.flasherLogger.logPrintln("device is in ramdisk as expected");
            }
            if (this.carrierList.length() == 0) {
                this.flasherLogger.logPrintln("WARNING - carrier list returned is empty, unless not checking for carrier in the case of NDI");
            } else {
                String carrierToken = this.getToken(CARRIER).toLowerCase();
                if (this.carrierList.contains(carrierToken)) {
                    this.flasherLogger.logPrintln("Found device Carrier match for :" + carrierToken);
                } else if (this.carrierList.length() > 0 && !this.carrierList.contains(carrierToken)) {
                    this.flasherLogger.logPrintln("WARING: carrierList on the webOS Dr is : " + this.carrierList + " and carrierToken on the device is : " + carrierToken);
                    this.rebootDeviceWithBootie();
                    throw new NovacomException(-1, "TOKEN MISMATCH: Failed to find match for Carrier information. Prevent user from flashing");
                }
            }
            if (this.modelList.length() == 0) {
                this.flasherLogger.logPrintln("WARNING - model list returned is empty, unless not checking for model in the case of NDI");
            } else {
                String modelToken = this.getToken(MODEL).toLowerCase();
                String prodID = this.getToken(PROD_ID).toLowerCase();
                if (this.modelList.contains(modelToken)) {
                    this.flasherLogger.logPrintln("Found device Model match for : " + modelToken);
                } else if (!this.modelList.contains(modelToken) && this.modelList.contains(prodID)) {
                    this.flasherLogger.logPrintln("Found device PRODoID match  : " + modelToken);
                } else if (this.modelList.length() > 0 && !this.modelList.contains(modelToken) && !this.modelList.contains(prodID)) {
                    this.flasherLogger.logPrintln("WARNING: modelList on the webOS Dr is : " + this.modelList + " and modelToken on the device is : " + modelToken + " prodID token is : " + prodID);
                    this.rebootDeviceWithBootie();
                    throw new NovacomException(-1, "TOKEN MISMATCH: Failed to find match for Model information. Prevent user from flashing");
                }
            }
            if (this.saveLogsBeforeFlash) {
                SaveLogsBeforeFlashStage saveLogStage = new SaveLogsBeforeFlashStage(this.device);
                saveLogStage.setProgressHandler(this);
                saveLogStage.run();
            }
            if (this.runDataMigrationStages) {
                DataPreCheckStage preCheckStage = new DataPreCheckStage(this.device);
                preCheckStage.setProgressHandler(this);
                preCheckStage.setFlasher(this);
                preCheckStage.run();
                if (this.preCheckValue) {
                    if (this.enableCmdLineMode) {
                        this.flasherLogger.logPrintln("running in CMDLineMode: muting the upgrade/restore option dialog");
                        if (this.goBackFlag) {
                            this.runDataRestoreStage = true;
                            if (this.prevBaseModel != null && this.prevCustomizationModel != null) {
                                this.baseModel = this.prevBaseModel;
                                this.customizationModel = this.prevCustomizationModel;
                                this.flasherLogger.logPrintln("running in CMDLineMode: goBackFlag enabled, switching to previous version of Base and Customizations");
                            }
                        } else {
                            this.flasherLogger.logPrintln("running in CMDLineMode: goBackFlag not enabled, upgrading device to latest version");
                        }
                    } else {
                        this.flasherLogger.logPrintln("PreCheckStage ret value is set to true");
                        UpgradePopupWindow.createGUI(this);
                        while (this.upgradeRestoreChoice.isEmpty()) {
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException ie) {
                                this.flasherLogger.logPrintln("swallowing Interrupted exception when user chooses migration path");
                            }
                        }
                        if (this.upgradeRestoreChoice.equals("restore") && this.prevBaseModel != null && this.prevCustomizationModel != null) {
                            this.runDataRestoreStage = true;
                            this.baseModel = this.prevBaseModel;
                            this.customizationModel = this.prevCustomizationModel;
                            this.flasherLogger.logPrintln("User chose to restore the device to previous stable build, NOT UPGRADING!");
                        } else if (this.upgradeRestoreChoice.equals("upgrade")) {
                            this.flasherLogger.logPrintln("User chose to UPGRADE the device to latest version.");
                        }
                    }
                }
            }
            if (this.runDataMigrationStages && this.preCheckValue) {
                DataSaveStage dataSaveStage = new DataSaveStage(this.device);
                dataSaveStage.setProgressHandler(this);
                dataSaveStage.setFlasher(this);
                dataSaveStage.run();
            }
            if (this.doDeleteAppDirectory) {
                AppFolderDeletionStage appFolderDeletionStage = new AppFolderDeletionStage(this.device);
                appFolderDeletionStage.setProgressHandler(this);
                appFolderDeletionStage.run();
            }
            ScreenPainter painter = new ScreenPainter(this.device);
            if (this.screenPicture == "") {
                painter.drawImageCentered(this.getClass().getResourceAsStream("/resources/flasher.png"));
            } else {
                painter.drawImageCentered(this.getClass().getResourceAsStream(this.screenPicture));
            }
            ++this.percentFlashedComplete;
            this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.PERCENT_UPDATE, this.percentFlashedComplete);
            TrenchcoatModel tcmodel = new TrenchcoatModel(this.baseModel, this.customizationModel, this.resizeRootFS);
            tcmodel.initDmSetsToken("NONE", "NONE");
            tcmodel.initBatteryCheckToken();
            if (tcmodel.getRFSOverLimitStatus()) {
                this.flasherLogger.logPrintln("WARNING - possibility of resizing the root partition to fit the RFS, /media/internal contents may be lost");
                if (this.doVerifyRfsSize) {
                    this.flasherLogger.logPrintln("ERROR - rfs+customization combo filesize is OVERLIMIT. RUNNING in WOSD mode");
                    this.rebootDeviceWithBootie();
                    throw new NovacomException(-1, "resizing root partition to fit the RFS, contents of /media/internal will be lost");
                }
            }
            this.percentFlashedComplete += 3;
            this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.PERCENT_UPDATE, this.percentFlashedComplete);
            if (null != this.massStorageData && 0 != this.massStorageData.length()) {
                tcmodel.addMassStorageData(this.massStorageData);
            } else {
                tcmodel.doPreserveMsmContents(this.doSaveMsm);
            }
            TrenchcoatStage trenchcoat = new TrenchcoatStage(tcmodel, this.device);
            trenchcoat.setProgressHandler(this);
            retries = 3;
            while (retries > 0) {
                try {
                    trenchcoat.run();
                    retries = 0;
                }
                catch (NovacomException e) {
                    this.flasherLogger.logPrintln(e.getErrorMessage());
                    if (0 == --retries) {
                        this.flasherLogger.logPrintln("trenchcoat retries exhausted");
                        throw new NovacomException(-1, "Trenchcoat failure, retries exhausted");
                    }
                    this.flasherLogger.logPrintln("retrying trenchcoat");
                }
            }
            if (!this.doSkipModemFwUpdate) {
                try {
                    ModemUpdateStage modemUpdater = new ModemUpdateStage(this.baseModel, this.device);
                    modemUpdater.setForceUpdate(this.doForceModemFwUpdate);
                    modemUpdater.setProgressHandler(this);
                    modemUpdater.run();
                }
                catch (FileNotFoundException e) {
                    this.flasherLogger.logPrintln("*** No modem firmware found in installer package, skipping modem update.");
                    this.endJob("Modem Updater");
                }
            } else {
                this.flasherLogger.logPrintln("*** modem fw, skipping update.");
            }
            if (this.customizationModel != null) {
                CustomizationStage customizer = null;
                customizer = new CustomizationStage(this.device, this.customizationModel);
                customizer.setProgressHandler(this);
                customizer.setSkipPriPrlSet(this.doSkipModemFwUpdate);
                customizer.run();
            } else {
                this.flasherLogger.logPrintln("no customization");
                this.endJob("Customization");
            }
            if (this.sideloadModel != null) {
                SideloadStage sideloader = null;
                sideloader = new SideloadStage(this.device, this.sideloadModel);
                sideloader.setProgressHandler(this);
                sideloader.run();
            }
            if (this.doVerifyRomImage) {
                VerifyRomStage verifyBaseRom = new VerifyRomStage(this.device);
                verifyBaseRom.setProgressHandler(this);
                verifyBaseRom.run();
            }
            if (null != this.softwareUpdateSiteFile && 0 != this.softwareUpdateSiteFile.length() && null != this.softwareUpdateSiteUrl && 0 != this.softwareUpdateSiteUrl.length()) {
                SoftwareUpdateSiteStage swupdateStage = new SoftwareUpdateSiteStage(this.device, this.softwareUpdateSiteFile, this.softwareUpdateSiteUrl);
                swupdateStage.setSupported(this.softwareUpdateSiteSupported);
                swupdateStage.setLabel(this.softwareUpdateSiteLabel);
                swupdateStage.setProgressHandler(this);
                swupdateStage.run();
            }
            if (this.doSkipFirstUse) {
                BypassFirstUseStage bypassFirstUse = new BypassFirstUseStage(this.device);
                bypassFirstUse.setProgressHandler(this);
                bypassFirstUse.run();
            }
            if (null != this.developerMode && 0 != this.developerMode.length()) {
                EnableNovacomUsbByDefaultStage novacomEnableState = new EnableNovacomUsbByDefaultStage(this.device, this.developerMode);
                novacomEnableState.setProgressHandler(this);
                novacomEnableState.run();
            }
            if (!this.doSkipTouchpanelUpdate) {
                try {
                    TouchPanelUpdateStage tpupdate = new TouchPanelUpdateStage(this.device);
                    tpupdate.setForceUpdate(this.doForceTouchpanelUpdate);
                    tpupdate.setProgressHandler(this);
                    tpupdate.run();
                }
                catch (FileNotFoundException e) {
                    this.flasherLogger.logPrintln("*** No touchpanel firmware found in installer package, skipping update.");
                    this.endJob("Touch Panel Updater");
                }
            } else {
                this.flasherLogger.logPrintln("*** touchpanel, skipping update.");
            }
            A6UpdateStage a6update = new A6UpdateStage(this.device);
            a6update.setProgressHandler(this);
            try {
                a6update.run();
            }
            catch (NovacomException e) {
                this.flasherLogger.logPrintln("A6 programming failure threw NovacomException - NOV-96046 " + e.getMessage());
            }
            catch (IOException e) {
                this.flasherLogger.logPrintln("A6 programming failure threw IOException - NOV-96046 " + e.getMessage());
            }
            if (null != this.postFlashScript && 0 != this.postFlashScript.length()) {
                this.runPostFlashScript();
            }
            if (this.runDataMigrationStages && this.runDataRestoreStage && this.dataSaveValue) {
                DataRestoreStage dataRestoreStage = new DataRestoreStage(this.device);
                dataRestoreStage.setProgressHandler(this);
                dataRestoreStage.run();
            }
            if ((machineType = this.device.getDeviceInfo().getMachineName().toLowerCase()).contentEquals("broadway") || machineType.contentEquals("windsor") || machineType.contentEquals("mantaray") || machineType.contentEquals("stingray") || machineType.contentEquals("roadrunner")) {
                this.flasherLogger.logPrintln("temporarily not restoring logs for newer devices");
            } else if (this.restoreLogsAfterFlash) {
                RestoreLogsAfterFlashStage restoreLogStage = new RestoreLogsAfterFlashStage(this.device);
                restoreLogStage.setProgressHandler(this);
                restoreLogStage.run();
            }
            this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.COMPLETED, null);
            try {
                INovacomStream stream = this.device.runProgram("/sbin/tellbootie", new String[]{"reboot"});
                stream.close();
            }
            catch (IOException e) {
            }
            catch (NovacomException e) {}
        }
        catch (IOException e) {
            this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.FAILED, e);
            e.printStackTrace();
        }
        catch (NovacomException e) {
            this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.FAILED, e);
            e.printStackTrace();
        }
    }

    private void runPostFlashScript() throws NovacomException, IOException {
        this.flasherLogger.logPrintln("Running Post Flash Script");
        INovacomStream output = this.device.putFile("/tmp/postflashscript.sh");
        FileInputStream fis = new FileInputStream(this.postFlashScript);
        DataInputStream scriptFileStream = new DataInputStream(fis);
        output.write(scriptFileStream);
        output.closeInput();
        output.closeOutput();
        output.waitForReturnCode();
        output.close();
        output = this.device.runProgram("/bin/sh", new String[]{"-c", "/tmp/postflashscript.sh"});
        output.waitForReturnCode();
        output.close();
    }

    private void rebootDeviceWithBootie() {
        try {
            INovacomStream stream = this.device.runProgram("/sbin/tellbootie", new String[]{"reboot"});
            stream.waitForReturnCode();
            stream.close();
        }
        catch (IOException e) {
        }
        catch (NovacomException novacomException) {
            // empty catch block
        }
        this.flasherLogger.logPrintln("Reboot call complete");
    }

    private void resetDevice() {
        try {
            INovacomStream stream = this.device.runProgram("", null);
            String command = "reset";
            byte[] bytes = command.getBytes("US-ASCII");
            stream.write(bytes);
            stream.closeOutput();
            String reply = stream.readLine();
            stream.close();
        }
        catch (IOException e) {
        }
        catch (NovacomException novacomException) {
            // empty catch block
        }
        this.flasherLogger.logPrintln("Reset call complete");
    }

    private String getToken(String token) throws IOException, NovacomException {
        String retString = null;
        StringBuffer script = new StringBuffer("#!/bin/sh\n/sbin/tokens --list | /bin/grep ");
        script.append(token);
        INovacomStream output = this.device.putFile("/tmp/get_token.sh");
        output.write(script.toString().getBytes("US-ASCII"));
        output.closeInput();
        output.closeOutput();
        output.waitForReturnCode();
        output.close();
        output = this.device.runProgram("/bin/sh", new String[]{"-c /tmp/get_token.sh"});
        String carrierInfo = output.readLine();
        carrierInfo = carrierInfo.replaceAll("['\"]", "");
        String[] tokens = carrierInfo.split(" ");
        retString = tokens[3] == null || tokens[3].length() == 0 ? "NOT_FOUND" : tokens[3];
        this.flasherLogger.logPrintln("token returned by get_token() is : " + retString);
        return retString;
    }

    @Override
    public Object startJob(String title, int increments) {
        this.flasherLogger.logPrintln("Starting: " + title);
        return title;
    }

    @Override
    public void updateJob(Object id, int progress) {
        System.out.println("update " + id + progress);
        if (id.equals("Modem Updater")) {
            int extra = progress * 20 / 100;
            this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.PERCENT_UPDATE, this.percentFlashedComplete + extra);
        } else if (id.equals("Loading Ramdisk")) {
            int extra = progress * 7 / 100;
            this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.PERCENT_UPDATE, this.percentFlashedComplete + extra);
        }
    }

    @Override
    public void commentOnJob(Object id, String comment) {
        if (comment.lastIndexOf(10) != -1) {
            this.flasherLogger.logPrint(id.toString() + ": " + comment);
        } else {
            this.flasherLogger.logPrintln(id.toString() + ": " + comment);
        }
        if (id.equals("Trenchcoat") && comment.startsWith("<INFO> ") && comment.endsWith(" percent complete\n")) {
            int start = "<INFO> ".length();
            int end = comment.indexOf(" ", start);
            String strPercent = comment.substring(start, end);
            try {
                int percent = new Integer(strPercent);
                int extra = percent * 40 / 100;
                this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.PERCENT_UPDATE, this.percentFlashedComplete + extra);
            }
            catch (NumberFormatException e) {
                this.flasherLogger.logPrintln("not a number");
            }
        }
    }

    @Override
    public void endJob(Object id) {
        if (id != null) {
            this.flasherLogger.logPrintln("Finished: " + id.toString());
            if (id.equals("Customization")) {
                this.percentFlashedComplete += 10;
            } else if (id.equals("Getting Into Update Mode")) {
                this.percentFlashedComplete += 2;
            } else if (id.equals("Modem Updater")) {
                this.percentFlashedComplete += 20;
            } else if (id.equals("Loading Ramdisk")) {
                this.percentFlashedComplete += 7;
            } else if (id.equals("Software Update Site Stage")) {
                this.percentFlashedComplete += 5;
            } else if (id.equals("Touch Panel Updater")) {
                this.percentFlashedComplete += 6;
            } else if (id.equals("Trenchcoat")) {
                this.percentFlashedComplete += 40;
            } else if (id.equals("ROM Verifyer")) {
                this.percentFlashedComplete += 5;
            } else if (!(id.equals("Battery Charger Stage") || id.equals("Bypass FirstUse") || id.equals("Sideload") || id.equals("Novacom Enabler") || id.equals("AppDeletion") || id.equals("A6 Updater") || id.equals("SaveLogsBeforeFlash") || id.equals("DataSaveStage") || id.equals("DataRestoreStage") || id.equals("DataPreCheckStage"))) {
                this.flasherLogger.logPrintln("Unexpected stage ended " + id);
                return;
            }
        } else {
            this.flasherLogger.logPrintln("null stage id on endJob");
        }
        this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.PERCENT_UPDATE, this.percentFlashedComplete);
    }

    public void setScreenPicture(String picture) {
        this.screenPicture = picture;
    }

    public void setMainWindow(IFlasherLogger mainWindow) {
        this.flasherLogger = mainWindow;
    }

    public void setDevice(INovacomDevice device) {
        this.device = device;
    }

    public void setDeveloperMode(String devMode) {
        if (null != devMode && 0 != devMode.trim().length()) {
            this.developerMode = devMode.trim();
        }
    }

    public void setSoftwareUpdateSite(String site, String url) {
        if (null != site && 0 != site.trim().length()) {
            this.softwareUpdateSiteFile = site.trim();
        }
        if (null != url && 0 != url.trim().length()) {
            this.softwareUpdateSiteUrl = url.trim();
        }
    }

    public void setSoftwareUpdateSite(String site, String url, String label, boolean isSupported) {
        this.softwareUpdateSiteSupported = isSupported;
        this.softwareUpdateSiteLabel = label;
        this.setSoftwareUpdateSite(site, url);
    }

    public void setMassStorageData(String data) {
        if (null != data && 0 != data.trim().length()) {
            this.massStorageData = data.trim();
        }
    }

    public void doVerifyRom(boolean doVerifyRom) {
        this.doVerifyRomImage = doVerifyRom;
    }

    public void doSkipBatteryCheck(boolean doSkipBatteryCeck) {
        this.doSkipBatteryCeck = doSkipBatteryCeck;
    }

    public void doSkipFirstUse(boolean doSkipFirstUseSetting) {
        this.doSkipFirstUse = doSkipFirstUseSetting;
    }

    public void doForceModemUpdate(boolean doForceModemUpdate) {
        this.doForceModemFwUpdate = doForceModemUpdate;
    }

    public void docheckCloud(boolean checkCloud) {
        this.checkCloudApi = checkCloud;
    }

    public void setPostFlashScript(String postFlashScript) {
        if (null != postFlashScript && 0 != postFlashScript.trim().length()) {
            this.postFlashScript = postFlashScript.trim();
        }
    }

    public void doSaveMsmPartition(boolean doTryToSaveMsm) {
        this.doSaveMsm = doTryToSaveMsm;
    }

    public void doSkipModemUpdate(boolean doSkipModemUpdate) {
        this.doSkipModemFwUpdate = doSkipModemUpdate;
    }

    public void doSkipTouchpanelUpdate(boolean doSkipTouchpanelUpdate) {
        this.doSkipTouchpanelUpdate = doSkipTouchpanelUpdate;
    }

    public void doForceTouchpanelUpdate(boolean doForceTouchpanelUpdate) {
        this.doForceTouchpanelUpdate = doForceTouchpanelUpdate;
    }

    public void setCarrierList(String carrierList) {
        this.carrierList = carrierList;
    }

    public void setModelList(String modelList) {
        this.modelList = modelList;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public void setDomName(String domName) {
        this.domName = domName;
    }

    public void setProdFile(String prodFile) {
        this.prodFile = prodFile;
    }

    public void doVerifyRfsSize(boolean doVerifyRfsSize) {
        this.doVerifyRfsSize = doVerifyRfsSize;
    }

    public void setSideload(ResourceInTarInstallerModel model) {
        this.sideloadModel = model;
    }

    public boolean getRFSOverLimitStatus() {
        return this.doVerifyRfsSize;
    }

    public void setCheckFlash(boolean checkToFlash) {
        this.checkToFlash = checkToFlash;
    }

    public void setDelAppDir(boolean delAppDir) {
        this.doDeleteAppDirectory = delAppDir;
    }

    public void setSaveLogsStage(boolean saveLogsBeforeFlash) {
        this.saveLogsBeforeFlash = saveLogsBeforeFlash;
    }

    public void setRestoreLogsStage(boolean restoreLogsAfterFlash) {
        this.restoreLogsAfterFlash = restoreLogsAfterFlash;
    }

    public void setDataMigrationStages(boolean runDataMigrationStages) {
        this.runDataMigrationStages = runDataMigrationStages;
    }

    public void setCmdLineModeFlag(boolean cmdLineMode) {
        this.enableCmdLineMode = cmdLineMode;
    }

    public void setGoBackFlag(boolean goBack) {
        this.goBackFlag = goBack;
    }

    public void setPrevBaseAndCust(InstallerModel prevBaseModel, TarredInstallerModel prevCustomizationModel) {
        this.prevBaseModel = prevBaseModel;
        this.prevCustomizationModel = prevCustomizationModel;
    }

    public void setUpgradeRestoreChoice(String choice) {
        this.upgradeRestoreChoice = choice;
    }

    public void retCodeFromPreCheck(boolean ret) {
        this.preCheckValue = ret;
    }

    public void retCodeFromDataSaveStage(boolean dataSave) {
        this.dataSaveValue = dataSave;
    }

    public void addToRootfsSize(int resizeRootFS) {
        this.resizeRootFS = resizeRootFS;
    }

    public void setLoadRamdisk(boolean choice) {
        this.loadRamdisk = choice;
    }
}

