/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.MountUtils;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class EnableNovacomUsbByDefaultStage
extends BaseStage {
    private static final String USBCTRL_PATH = "/gadget/";
    private static final String TEMP_VARFS = "/tmp_rootfs";
    private static final String RUNNER_NAME = "Novacom Enabler";
    private static final String MKDIR = "/bin/mkdir";
    private static final String TOUCH = "/bin/touch";
    private final INovacomDevice device;
    private Object jobId;
    private final String developerMode;

    public EnableNovacomUsbByDefaultStage(INovacomDevice device, String developerMode) {
        this.device = device;
        this.developerMode = developerMode;
    }

    public void run() throws IOException, NovacomException {
        if (null != this.developerMode && 0 < this.developerMode.length()) {
            IStageProgressReporter reporter = this.getProgressHandler();
            this.jobId = reporter.startJob(RUNNER_NAME, 100);
            MountUtils mountUtils = new MountUtils(this.device);
            mountUtils.mount(MountUtils.MountParts.VARFS, MountUtils.FsType.EXT3, TEMP_VARFS);
            this.getProgressHandler().commentOnJob(this.jobId, "Enabling Novacom support");
            this.runCommand(MKDIR, new String[]{"-p", "/tmp_rootfs/gadget/"});
            this.runCommand(TOUCH, new String[]{"/tmp_rootfs/gadget/novacom_enabled"});
            if (this.developerMode.equals("usbnet_enable")) {
                this.runCommand(TOUCH, new String[]{"/tmp_rootfs/gadget/usbnet_enabled"});
            }
            mountUtils.umount(MountUtils.MountParts.VARFS);
            reporter.endJob(this.jobId);
        }
    }

    public String toString() {
        return RUNNER_NAME;
    }

    private void runCommand(String command, String[] args) throws IOException, NovacomException {
        if (args == null) {
            args = new String[]{};
        }
        INovacomStream stream = this.device.runProgram(command, args);
        stream.flush();
        this.printStreamToProgressReporter(stream);
    }

    private void printStreamToProgressReporter(INovacomStream stream) throws IOException, NovacomException {
        this.printStreamToProgressReporter(stream, true);
    }

    private void printStreamToProgressReporter(INovacomStream stream, Boolean closeStream) throws IOException, NovacomException {
        String line = stream.readLine();
        while (line.compareTo("") != 0) {
            this.getProgressHandler().commentOnJob(this.jobId, line);
            line = stream.readLine();
        }
        if (closeStream.booleanValue()) {
            stream.flush();
            stream.close();
        }
    }
}

