/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.recoverytool;

import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import com.palm.nova.installer.core.FlasherThread;
import com.palm.nova.installer.core.IFlasherLogger;
import com.palm.nova.installer.core.LoggerUtils;
import com.palm.nova.installer.core.RdxUtils;
import com.palm.nova.installer.core.TarInJarInstallerModel;
import com.palm.nova.installer.core.TarfileInstallerModel;
import com.palm.nova.installer.core.TarredInstallerModel;
import com.palm.nova.installer.recoverytool.BareBonesBrowserLaunch;
import com.palm.nova.installer.recoverytool.Base64;
import com.palm.nova.installer.recoverytool.BatteryCharger;
import com.palm.nova.installer.recoverytool.ConfigFileMgr;
import com.palm.nova.installer.recoverytool.cards.BatteryChargingCard;
import com.palm.nova.installer.recoverytool.cards.BeginFlashingCard;
import com.palm.nova.installer.recoverytool.cards.BootiefyCard;
import com.palm.nova.installer.recoverytool.cards.CheckSystemCard;
import com.palm.nova.installer.recoverytool.cards.ConfirmLanguageCard;
import com.palm.nova.installer.recoverytool.cards.ConnectDeviceCard;
import com.palm.nova.installer.recoverytool.cards.DeviceUnpluggedCard;
import com.palm.nova.installer.recoverytool.cards.EndFlashingCard;
import com.palm.nova.installer.recoverytool.cards.EulaCard;
import com.palm.nova.installer.recoverytool.cards.FlashingFailedCard;
import com.palm.nova.installer.recoverytool.cards.FlashingProgressCard;
import com.palm.nova.installer.recoverytool.cards.LanguagePickerCard;
import com.palm.nova.installer.recoverytool.cards.Messages;
import com.palm.nova.installer.recoverytool.cards.TokenMismatchFailedCard;
import com.palm.nova.installer.recoverytool.runner.DeviceDiscoveryRunner;
import com.palm.nova.installer.recoverytool.runner.RunnerCallback;
import com.palm.nova.installer.recoverytool.runner.SystemCheckRunner;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.NovacomException;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.synth.SynthLookAndFeel;

public class CardController
extends JFrame
implements ActionListener,
RunnerCallback,
IFlasherLogger {
    private static final long serialVersionUID = -5685004007837089200L;
    private final Logger logger = Logger.getLogger("com.palm.recoverytool");
    INovacomDevice device = null;
    public static final String BACKGROUND_NORMAL = "/resources/bg1.png";
    public static final String BACKGROUND_DEVICE_ATTACH = "/resources/bg2.png";
    public static final String BACKGROUND_NO_WARNING_ICON = "/resources/bg3.png";
    String currentBackgroundName;
    JLabel backlabel;
    JPanel cards;
    private static final String szLangPickerCard = "langPickerCard";
    LanguagePickerCard langPickerCard;
    private static final String szConfirmLanguageCard = "confirmLanguageCard";
    ConfirmLanguageCard confirmLanguageCard;
    private static final String szEulaCard = "eulaCard";
    EulaCard eulaCard;
    private static final String szBeginCard = "beginFlashingCard";
    BeginFlashingCard beginCard;
    private static final String szCheckSystemCard = "checkSystemCard";
    CheckSystemCard checkSystemCard;
    private static final String szConnectDeviceCard = "connectDeviceCard";
    ConnectDeviceCard connectDeviceCard;
    private static final String szBatteryChargingCard = "batteryChargingCard";
    BatteryChargingCard batteryChargingCard;
    private static final String szFlashProgressCard = "flashProgressCard";
    FlashingProgressCard flashProgressCard;
    private static final String szEndFlashingCard = "endFlashingCard";
    EndFlashingCard endFlashingCard;
    private static final String szFlashingFailedCard = "flashingFailedCard";
    FlashingFailedCard flashingFailedCard;
    private static final String szTokenMismatchFailedCard = "tokenMismatchFailedCard";
    TokenMismatchFailedCard tokenMismatchFailedCard;
    private static final String szDeviceUnpluggedCard = "deviceUnpluggedCard";
    DeviceUnpluggedCard deviceUnpluggedCard;
    private static final String szBootiefyCard = "bootiefyCard";
    BootiefyCard bootiefyCard;
    JPanel currentCard;
    JButton flowPathBtn;
    JButton secondBtn;
    static final int RUNNER_ID_DEVICE_DISCOVERY = 1;
    private final DeviceDiscoveryRunner deviceDiscoveryRunner;
    static final int RUNNER_ID_SYSTEM_CHECK = 2;
    private final SystemCheckRunner systemCheckRunner;
    private BatteryCharger batteryCharger;
    private FlasherThread flashRunner;

    public static void saveLogs() {
        RdxUtils.saveLogs("PalmWebOsRecoveryToolLog");
    }

    private void launchHelpUrl() {
        BareBonesBrowserLaunch.openURL(Messages.getString("CardController.14"));
    }

    private void launchSupportUrl() {
        BareBonesBrowserLaunch.openURL(Messages.getString("FlashingFailedCard.5"));
    }

    private void launchTokenMismatchUrl() {
        BareBonesBrowserLaunch.openURL(Messages.getString("FlashingFailedCard.7"));
    }

    public CardController() {
        super("Palm(R) webOS(tm) Doctor (Build " + ConfigFileMgr.getInstance().getPhoenixBuildVersion() + ")");
        this.logger.info("+++++CardController");
        this.deviceDiscoveryRunner = new DeviceDiscoveryRunner(this, 1);
        this.systemCheckRunner = new SystemCheckRunner(this, 2);
        this.setDefaultCloseOperation(3);
        SynthLookAndFeel lookAndFeel = new SynthLookAndFeel();
        InputStream synthInStream = this.getClass().getResourceAsStream("/resources/synthSkin.xml");
        try {
            lookAndFeel.load(synthInStream, this.getClass());
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
            this.logger.log(Level.WARNING, "", e1);
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
            this.logger.log(Level.WARNING, "", e);
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(null);
        contentPane.setSize(800, 600);
        contentPane.setOpaque(false);
        Properties langPickerProps = new Properties();
        try {
            InputStream langPickerPropsFile = this.getClass().getResourceAsStream("/resources/languagePicker.properties");
            if (langPickerPropsFile != null) {
                langPickerProps.load(langPickerPropsFile);
            } else {
                langPickerProps.setProperty("Default", "English");
                langPickerProps.setProperty("Espa\u00f1ol", "es_US");
                langPickerProps.setProperty("English", "en_US");
            }
        }
        catch (IOException e) {
            langPickerProps.setProperty("Default", "English");
            langPickerProps.setProperty("Espa\u00f1ol", "es_US");
            langPickerProps.setProperty("English", "en_US");
        }
        String defaultLanguage = langPickerProps.getProperty("Default");
        if (defaultLanguage != null) {
            langPickerProps.remove("Default");
        } else {
            defaultLanguage = "English";
        }
        String getLocale = langPickerProps.getProperty(defaultLanguage);
        this.logger.info("getLocale is : " + getLocale);
        String[] parts = getLocale.split("_");
        Locale newLocale = parts.length == 3 ? new Locale(parts[0], parts[1], parts[2]) : (parts.length == 2 ? new Locale(parts[0], parts[1]) : (parts.length == 1 ? new Locale(parts[0]) : Locale.ENGLISH));
        Locale.setDefault(newLocale);
        this.currentBackgroundName = BACKGROUND_NORMAL;
        URL imgURL = this.getClass().getResource(BACKGROUND_NORMAL);
        ImageIcon imageIcon = new ImageIcon(imgURL, "background");
        this.backlabel = new JLabel(imageIcon);
        JLayeredPane layeredPane = this.getLayeredPane();
        this.backlabel.setBounds(0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        layeredPane.add((Component)this.backlabel, (Object)Integer.MIN_VALUE);
        this.secondBtn = new JButton(Messages.getString("CardBase.1"));
        this.secondBtn.setEnabled(true);
        this.secondBtn.setActionCommand("secondButton");
        this.secondBtn.addActionListener(this);
        this.flowPathBtn = new JButton(Messages.getString("CardBase.0"));
        this.flowPathBtn.addActionListener(this);
        this.flowPathBtn.setEnabled(true);
        this.flowPathBtn.setName("NextButton");
        this.cards = new JPanel(new CardLayout());
        this.cards.setOpaque(false);
        this.langPickerCard = new LanguagePickerCard(this);
        this.cards.add((Component)this.langPickerCard, szLangPickerCard);
        this.langPickerCard.setVisible(true);
        this.cards.setBounds(375, 170, 385, 185);
        contentPane.add(this.cards);
        this.secondBtn.setBounds(535, 370, 110, 30);
        contentPane.add(this.secondBtn);
        this.flowPathBtn.setBounds(650, 370, 110, 30);
        contentPane.add(this.flowPathBtn);
        this.setSize(800, 600);
        this.setResizable(false);
        this.setVisible(true);
    }

    public void setFlowButton(final String text, final boolean enabled, final boolean visible) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (text.equals("GreenCheckboxButton")) {
                    CardController.this.flowPathBtn.setName("GreenButton");
                    CardController.this.flowPathBtn.setText("");
                } else {
                    CardController.this.flowPathBtn.setName("NextButton");
                    CardController.this.flowPathBtn.setText(text);
                }
                CardController.this.flowPathBtn.setVisible(visible);
                CardController.this.flowPathBtn.setEnabled(enabled);
            }
        });
    }

    public void setSecondButton(final String text, final boolean visible) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (text.equals("RedExButton")) {
                    CardController.this.secondBtn.setName("RedButton");
                    CardController.this.secondBtn.setVisible(visible);
                    CardController.this.secondBtn.setText("");
                } else {
                    CardController.this.secondBtn.setName("Button");
                    CardController.this.secondBtn.setText(text);
                    CardController.this.secondBtn.setVisible(visible);
                }
            }
        });
    }

    public void setBackgroundImage(final String newBackground) {
        if (!this.currentBackgroundName.equals(newBackground)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CardController.this.currentBackgroundName = newBackground;
                    URL imgURL = this.getClass().getResource(newBackground);
                    ImageIcon imageIcon = new ImageIcon(imgURL, "background");
                    CardController.this.backlabel.setIcon(imageIcon);
                }
            });
        }
    }

    private void gotoNextCard() {
        CardLayout cl = (CardLayout)this.cards.getLayout();
        if (this.currentCard == this.connectDeviceCard && this.device != null) {
            cl.show(this.cards, szBatteryChargingCard);
        } else if (this.currentCard == this.deviceUnpluggedCard) {
            cl.show(this.cards, szConnectDeviceCard);
        } else if (this.currentCard == this.langPickerCard) {
            this.cards.removeAll();
            this.cards.add((Component)this.langPickerCard, szLangPickerCard);
            this.langPickerCard.setVisible(true);
            this.confirmLanguageCard = new ConfirmLanguageCard(this);
            this.cards.add((Component)this.confirmLanguageCard, szConfirmLanguageCard);
            this.eulaCard = new EulaCard(this);
            this.cards.add((Component)this.eulaCard, szEulaCard);
            this.beginCard = new BeginFlashingCard(this);
            this.cards.add((Component)this.beginCard, szBeginCard);
            this.checkSystemCard = new CheckSystemCard(this);
            this.cards.add((Component)this.checkSystemCard, szCheckSystemCard);
            this.connectDeviceCard = new ConnectDeviceCard(this);
            this.cards.add((Component)this.connectDeviceCard, szConnectDeviceCard);
            this.bootiefyCard = new BootiefyCard(this);
            this.cards.add((Component)this.bootiefyCard, szBootiefyCard);
            this.batteryChargingCard = new BatteryChargingCard(this);
            this.cards.add((Component)this.batteryChargingCard, szBatteryChargingCard);
            this.flashProgressCard = new FlashingProgressCard(this);
            this.cards.add((Component)this.flashProgressCard, szFlashProgressCard);
            this.endFlashingCard = new EndFlashingCard(this);
            this.cards.add((Component)this.endFlashingCard, szEndFlashingCard);
            this.deviceUnpluggedCard = new DeviceUnpluggedCard(this);
            this.cards.add((Component)this.deviceUnpluggedCard, szDeviceUnpluggedCard);
            this.flashingFailedCard = new FlashingFailedCard(this);
            this.cards.add((Component)this.flashingFailedCard, szFlashingFailedCard);
            this.tokenMismatchFailedCard = new TokenMismatchFailedCard(this);
            this.cards.add((Component)this.tokenMismatchFailedCard, szTokenMismatchFailedCard);
            this.secondBtn.setText(Messages.getString("CardBase.1"));
            cl.show(this.cards, szConfirmLanguageCard);
        } else {
            cl.next(this.cards);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("launchHelp")) {
            this.launchSupportUrl();
        } else if (e.getActionCommand().equals("launchTokenMismatchHelp")) {
            this.launchTokenMismatchUrl();
        } else if (e.getActionCommand().equals("secondButton")) {
            if (this.currentCard == this.confirmLanguageCard) {
                CardLayout cl = (CardLayout)this.cards.getLayout();
                this.langPickerCard.resetFlowButton();
                cl.show(this.cards, szLangPickerCard);
            } else {
                this.launchHelpUrl();
            }
        } else if (e.getActionCommand().equals("langPicker")) {
            Locale.setDefault(this.langPickerCard.getLocale());
            Messages.resetLocal();
            this.flowPathBtn.setText(Messages.getString("CardBase.0"));
        } else if (this.currentCard == this.endFlashingCard || this.currentCard == this.flashingFailedCard || this.currentCard == this.tokenMismatchFailedCard) {
            System.exit(0);
        } else {
            this.gotoNextCard();
        }
    }

    public void lookForDevice(Long timeout) {
        this.deviceDiscoveryRunner.setTimeout(timeout);
        this.deviceDiscoveryRunner.start();
    }

    public void startCheckSystem() {
        this.flowPathBtn.setEnabled(false);
        this.setDefaultCloseOperation(0);
        this.systemCheckRunner.start();
    }

    public void setCurrentCardState(JPanel currentCard) {
        this.currentCard = currentCard;
    }

    public void startBatteryCharge() {
        this.batteryCharger = new BatteryCharger(this);
        this.batteryCharger.setDevice(this.device);
        new Thread(this.batteryCharger).start();
    }

    public void batteryChargingFinished(Exception e) {
        if (null == e) {
            this.gotoNextCard();
        } else {
            this.logger.log(Level.WARNING, "Battery Charge Failure:", e);
            this.logger.info("Battery Charging End time (Fail) " + System.currentTimeMillis());
            this.handleFailCase();
        }
    }

    public static String readInputStreamAsString(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            byte b = (byte)result;
            buf.write(b);
            result = bis.read();
        }
        return buf.toString();
    }

    public void startFlash() {
        try {
            TarEntry te;
            TarInputStream ts;
            byte[] bits;
            if (this.device == null) {
                throw new NovacomException(-1, "no valid device attached");
            }
            this.flowPathBtn.setEnabled(false);
            this.logger.info("Start time " + System.currentTimeMillis());
            this.logger.info("looking for /resources/" + ConfigFileMgr.getInstance().getBaseBuildFilename());
            InputStream inStream = this.getClass().getResourceAsStream("/resources/" + ConfigFileMgr.getInstance().getBaseBuildFilename());
            String baseFullPathAndName = null;
            String custFullPathAndName = null;
            String sri = ConfigFileMgr.getInstance().getApprovalReleaseHash();
            String carrier = ConfigFileMgr.getInstance().getApprovalCharlieHash();
            String model = ConfigFileMgr.getInstance().getApprovalMikeHash();
            String deviceType = ConfigFileMgr.getInstance().getDeviceType();
            String carrierList = null;
            String modelList = null;
            TarredInstallerModel baseModel = null;
            TarredInstallerModel custModel = null;
            String baseBuildFileName = ConfigFileMgr.getInstance().getBaseBuildFilename();
            String custBuildFileName = ConfigFileMgr.getInstance().getCustomizationFileName();
            URL dir = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            this.logger.info(this.getClass().getName() + " is loaded from: " + dir);
            File jarFile = new File(dir.getFile());
            this.logger.info("jarFile path is: " + jarFile);
            if (jarFile.isDirectory()) {
                this.logger.warning("not running from jar");
                throw new FileNotFoundException("Failed To Load Build File");
            }
            baseFullPathAndName = jarFile.getParent() + "/" + baseBuildFileName;
            custFullPathAndName = jarFile.getParent() + "/" + custBuildFileName;
            this.logger.info("full path of the baseBuild file outside jar is: " + baseFullPathAndName);
            this.logger.info("full path of the customizationBuild file outside jar is: " + custFullPathAndName);
            if (new File(baseFullPathAndName).exists() && new File(custFullPathAndName).exists()) {
                this.logger.info("Loading the base tar from outside the jar with path: " + baseFullPathAndName);
                this.logger.info("Loading the customization tar from outside the jar with path: " + custFullPathAndName);
                baseModel = new TarfileInstallerModel(new File(baseFullPathAndName));
                custModel = new TarfileInstallerModel(new File(custFullPathAndName));
                this.logger.info("no issues loading baseModel or custModel Tarfiles outside the jar");
            } else if (inStream != null) {
                this.logger.info("found resource in jar");
                baseFullPathAndName = "/resources/" + baseBuildFileName;
                baseModel = new TarInJarInstallerModel(baseFullPathAndName);
                this.logger.info("Base build file found inside jar and loaded sucessfully");
                if (custBuildFileName != null && custBuildFileName.length() > 0) {
                    custFullPathAndName = "/resources/" + custBuildFileName;
                    custModel = new TarInJarInstallerModel(custFullPathAndName);
                    this.logger.info("Customization build file found inside jar and loaded sucessfully");
                } else {
                    custModel = null;
                }
            } else if (inStream == null || !new File(baseFullPathAndName).exists() || !new File(custFullPathAndName).exists()) {
                this.logger.warning("Could not find base and customization tar files inside or next to the jar file");
                throw new FileNotFoundException("Failed to find base/customization build files");
            }
            if (null != sri) {
                bits = Base64.decode(sri.getBytes("US-ASCII"));
                if (null != bits) {
                    ts = new TarInputStream(new GZIPInputStream(new ByteArrayInputStream(bits)));
                    te = ts.getNextEntry();
                    if (null != te) {
                        sri = te.getName();
                    }
                } else {
                    sri = null;
                }
            }
            this.flashRunner = new FlasherThread(baseModel, custModel);
            if (null != carrier && null != (bits = Base64.decode(carrier.getBytes("US-ASCII"))) && null != (te = (ts = new TarInputStream(new GZIPInputStream(new ByteArrayInputStream(bits)))).getNextEntry()) && (carrier = te.getName()).endsWith("txt")) {
                carrierList = CardController.readInputStreamAsString(ts);
                carrierList = carrierList.replaceAll("\n", "");
                this.flashRunner.setCarrierList(carrierList.toLowerCase());
            }
            if (null != model && null != (bits = Base64.decode(model.getBytes("US-ASCII"))) && null != (te = (ts = new TarInputStream(new GZIPInputStream(new ByteArrayInputStream(bits)))).getNextEntry()) && (model = te.getName()).endsWith("txt")) {
                modelList = CardController.readInputStreamAsString(ts);
                modelList = modelList.replaceAll("\n", "");
                this.flashRunner.setModelList(modelList.toLowerCase());
            }
            this.flashRunner.setDeviceType(deviceType.toLowerCase());
            if (null != sri && null != ConfigFileMgr.getInstance().getSoftwareUpdateSite()) {
                StringBuilder url = new StringBuilder("https://");
                url.append("mypretty@golum.");
                url.append("palm.com/location-dir/getdomain/");
                this.flashRunner.setSoftwareUpdateSite(ConfigFileMgr.getInstance().getSoftwareUpdateSite(), url.toString().replace("mypretty@golum", sri));
            }
            this.flashRunner.doVerifyRom(true);
            this.flashRunner.doForceModemUpdate(ConfigFileMgr.getInstance().doForceModemUpdate());
            this.flashRunner.doSaveMsmPartition(true);
            this.flashRunner.setDevice(this.device);
            this.flashRunner.setMainWindow(this);
            this.setDefaultCloseOperation(0);
            new Thread(this.flashRunner).start();
        }
        catch (IOException e) {
            e.printStackTrace();
            LoggerUtils.getInstance().getLogger("FlashingProgressCard").log(Level.WARNING, "", e);
            this.logger.warning("ioexception setting up flash, move to failed card");
            CardLayout cl = (CardLayout)this.cards.getLayout();
            cl.show(this.cards, szFlashingFailedCard);
            CardController.saveLogs();
        }
        catch (NovacomException e) {
            e.printStackTrace();
            LoggerUtils.getInstance().getLogger("FlashingProgressCard").log(Level.WARNING, "", e);
            this.logger.warning("novacom exception setting up flash, move to failed card");
            CardLayout cl = (CardLayout)this.cards.getLayout();
            cl.show(this.cards, szFlashingFailedCard);
            CardController.saveLogs();
        }
    }

    private void handleFailCase() {
        CardController.saveLogs();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.logger.info("something failed, query to see if device is plugged in");
        this.lookForDevice(5000L);
        this.logger.info("exiting handleFailCase()");
    }

    private void handleTokenFailCase() {
        this.device = this.deviceDiscoveryRunner.getResult();
        if (this.currentCard == this.flashProgressCard) {
            CardLayout cl = (CardLayout)this.cards.getLayout();
            if (this.device == null) {
                this.logger.warning("the device seems to have been unplugged, try again");
                cl.show(this.cards, szDeviceUnpluggedCard);
            } else {
                this.logger.warning("flashing failed, move to Token failed card");
                cl.show(this.cards, szTokenMismatchFailedCard);
            }
        }
    }

    public void runnerFinished(int id) {
        switch (id) {
            case 1: {
                this.logger.info("device runner done");
                this.device = this.deviceDiscoveryRunner.getResult();
                if (this.currentCard == this.connectDeviceCard) {
                    this.flowPathBtn.setEnabled(true);
                    break;
                }
                if (this.currentCard == this.connectDeviceCard) {
                    this.gotoNextCard();
                    break;
                }
                if (this.currentCard != this.batteryChargingCard && this.currentCard != this.flashProgressCard) break;
                CardLayout cl = (CardLayout)this.cards.getLayout();
                if (this.device == null) {
                    this.logger.warning("the device seems to have been unplugged, try again");
                    cl.show(this.cards, szDeviceUnpluggedCard);
                    break;
                }
                this.logger.warning("flashing failed, move to failed card");
                cl.show(this.cards, szFlashingFailedCard);
                break;
            }
            case 2: {
                this.setDefaultCloseOperation(3);
                if (this.systemCheckRunner.getResult().booleanValue()) {
                    this.gotoNextCard();
                    break;
                }
                this.logger.warning("failed to install drivers, move to failed card");
                CardLayout cl = (CardLayout)this.cards.getLayout();
                cl.show(this.cards, szFlashingFailedCard);
                CardController.saveLogs();
                break;
            }
        }
    }

    public void batteryChargingUpdate(int progress) {
        this.logger.info("battery check update");
        this.batteryChargingCard.batterySetCurrent(progress);
    }

    public void runnerHasUpdate(int id, Object o) {
        switch (id) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void logPrint(String data) {
        this.logger.info(data);
    }

    public void logPrintln(String data) {
        this.logPrint(data + "\n");
    }

    public void postFlashEvent(IFlasherLogger.FlashEvents event, Object obj) {
        switch (event) {
            case COMPLETED: {
                this.setDefaultCloseOperation(3);
                this.logger.info("Flash End time (Success)" + System.currentTimeMillis());
                this.gotoNextCard();
                break;
            }
            case FAILED: {
                this.setDefaultCloseOperation(3);
                Exception e = (Exception)obj;
                this.logger.log(Level.WARNING, "Flash Failure ", e);
                this.logger.info("Flash End time (Fail) " + System.currentTimeMillis());
                if (e.getMessage().contains("TOKEN MISMATCH: Failed to find match for")) {
                    this.handleTokenFailCase();
                    break;
                }
                this.handleFailCase();
                break;
            }
            case PERCENT_UPDATE: {
                int percent = (Integer)obj;
                this.flashProgressCard.setPercent(percent);
            }
        }
    }
}

