/*
 * Decompiled with CFR 0.152.
 */
package com.palm.novacom.internal;

import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.NovacomException;
import com.palm.novacom.internal.NovacomDevice;
import com.palm.novacom.internal.NovacomDeviceList;
import com.palm.novacom.internal.NovacomSocketStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;

public class NovacomController
implements INovacomController {
    private final String host;
    private final int port;

    public NovacomController(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public INovacomDevice connectDefaultDevice() throws IOException, NovacomException {
        NovaDeviceInfo[] devices = this.getDeviceList();
        if (devices.length <= 0) {
            throw new NovacomException(-1, "No devices attached on " + this.host + "@" + this.port);
        }
        return this.connectToDevice(devices[0]);
    }

    public INovacomDevice connectToDevice(NovaDeviceInfo devInfo) throws IOException, NovacomException {
        return new NovacomDevice(this.host, devInfo);
    }

    public NovaDeviceInfo[] getDeviceList() throws IOException, NovacomException {
        Socket socket = new Socket(this.host, this.port);
        NovacomSocketStream stream = new NovacomSocketStream(socket, "Device List Stream");
        stream.setPacketMode(false);
        NovacomDeviceList deviceList = new NovacomDeviceList(stream);
        NovaDeviceInfo[] list = deviceList.getDevices();
        try {
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public NovaDeviceInfo[] getDeviceListOnUsb() throws IOException, NovacomException {
        NovaDeviceInfo[] list = this.getDeviceList();
        ArrayList<NovaDeviceInfo> arrayList = new ArrayList<NovaDeviceInfo>(list.length);
        if (0 < list.length) {
            for (NovaDeviceInfo device : list) {
                if (!"usb".equals(device.getTransport())) continue;
                arrayList.add(device);
            }
        }
        return arrayList.toArray(new NovaDeviceInfo[0]);
    }
}

