/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.recoverytool.runner;

import com.palm.nova.installer.recoverytool.runner.Runner;
import com.palm.nova.installer.recoverytool.runner.RunnerCallback;
import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceDiscoveryRunner
extends Runner<INovacomDevice> {
    INovacomDevice defaultDevice = null;
    Logger logger = Logger.getLogger("com.palm.recoverytool");
    Long timeout = null;

    public DeviceDiscoveryRunner(RunnerCallback callbackClass, int id) {
        super(callbackClass, id);
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Override
    protected void initThread() {
        this.defaultDevice = null;
        this.thread = new DeviceDiscoveryThread();
    }

    @Override
    public INovacomDevice getResult() {
        return this.defaultDevice;
    }

    private class DeviceDiscoveryThread
    extends Thread {
        private DeviceDiscoveryThread() {
        }

        public void run() {
            block7: {
                long startTime = System.currentTimeMillis();
                do {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    try {
                        INovacomController controller = Novacom.getController();
                        DeviceDiscoveryRunner.this.logger.info("got controller");
                        NovaDeviceInfo[] devices = controller.getDeviceListOnUsb();
                        DeviceDiscoveryRunner.this.logger.info("got devices " + devices.length);
                        if (devices.length > 0) {
                            DeviceDiscoveryRunner.this.defaultDevice = controller.connectToDevice(devices[0]);
                        }
                        if (DeviceDiscoveryRunner.this.defaultDevice == null) continue;
                        DeviceDiscoveryRunner.this.logger.fine("got device");
                        break block7;
                    }
                    catch (IOException e) {
                        DeviceDiscoveryRunner.this.logger.log(Level.WARNING, "Unable to connect to NovaCOMd -- is it running???", e);
                    }
                    catch (NovacomException e) {
                        DeviceDiscoveryRunner.this.logger.log(Level.WARNING, "NovacomException trying connect to NovaCOMd -- keep trying", e);
                    }
                } while (DeviceDiscoveryRunner.this.timeout == null || System.currentTimeMillis() < startTime + DeviceDiscoveryRunner.this.timeout);
                DeviceDiscoveryRunner.this.logger.info("timed out looking for device");
                DeviceDiscoveryRunner.this.defaultDevice = null;
            }
            DeviceDiscoveryRunner.this.done();
        }
    }
}

