/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.recoverytool.cards;

import com.palm.nova.installer.recoverytool.CardController;
import com.palm.nova.installer.recoverytool.cards.Messages;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public abstract class CardBase
extends JPanel {
    private static final long serialVersionUID = 4248759736250976385L;
    String background = "/resources/bg1.png";
    protected CardController cardController;
    String flowButtonText = Messages.getString("CardBase.0");
    boolean flowButtonEnabled = true;
    boolean flowButtonVisible = true;
    String secondButtonText = Messages.getString("CardBase.1");
    boolean secondButtonVisible = true;
    float boxAlignment = 0.0f;
    public static final String flowButtonDefaultString = "CardBase.0";
    public static final String secondButtonDefaultString = "CardBase.1";

    protected void initBackground(String background) {
        this.background = background;
    }

    protected void setBoxAligmnet(float alignmentX) {
        this.boxAlignment = alignmentX;
    }

    protected void initFlowButton(String text, Boolean enabled, Boolean visible) {
        if (text != null) {
            this.flowButtonText = text;
        }
        if (enabled != null) {
            this.flowButtonEnabled = enabled;
        }
        if (visible != null) {
            this.flowButtonVisible = visible;
        }
    }

    protected void initSecondButton(String text, Boolean visible) {
        if (text != null) {
            this.secondButtonText = text;
        }
        if (visible != null) {
            this.secondButtonVisible = visible;
        }
    }

    protected JPanel adCenteredText(String text, int fontStyle, int size) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1));
        panel.setAlignmentX(this.boxAlignment);
        panel.setOpaque(false);
        JTextArea textArea = new JTextArea(text);
        textArea.setFont(new Font("SansSerif", fontStyle, size));
        textArea.setLineWrap(false);
        textArea.setWrapStyleWord(false);
        textArea.setEditable(false);
        textArea.setForeground(Color.WHITE);
        textArea.setOpaque(false);
        textArea.setVisible(true);
        panel.add(textArea);
        this.add(panel);
        return panel;
    }

    protected JLabel addLabel(String text, int fontStyle) {
        return this.addLabel(text, fontStyle, 12);
    }

    protected JLabel addLabel(String text, int fontStyle, int size) {
        JLabel label = new JLabel(text);
        label.setFont(new Font("SansSerif", fontStyle, size));
        label.setAlignmentX(this.boxAlignment);
        label.setOpaque(false);
        label.setVisible(true);
        label.setForeground(Color.WHITE);
        this.add(label);
        return label;
    }

    protected JTextArea addText(String text, boolean visible, int fontStyle) {
        JTextArea textArea = new JTextArea(text);
        textArea.setFont(new Font("SansSerif", fontStyle, 12));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        textArea.setForeground(Color.WHITE);
        textArea.setOpaque(false);
        textArea.setVisible(visible);
        textArea.setAlignmentX(this.boxAlignment);
        this.add(textArea);
        return textArea;
    }

    protected JLabel addIcon(String resourceName) {
        URL imgURL = CardBase.class.getResource(resourceName);
        ImageIcon imageIcon = new ImageIcon(imgURL, resourceName);
        JLabel label = new JLabel(imageIcon);
        label.setBounds(0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        label.setAlignmentX(this.boxAlignment);
        this.add(label);
        return label;
    }

    protected void addFiller() {
        this.addFiller(10);
    }

    protected void addFiller(int size) {
        Dimension diminsion = new Dimension(size, size);
        Box.Filler filler = new Box.Filler(diminsion, diminsion, diminsion);
        filler.setAlignmentX(this.boxAlignment);
        this.add(filler);
    }

    public void setVisible(boolean flag) {
        if (flag) {
            this.cardController.setBackgroundImage(this.background);
            this.cardController.setFlowButton(this.flowButtonText, this.flowButtonEnabled, this.flowButtonVisible);
            this.cardController.setSecondButton(this.secondButtonText, this.secondButtonVisible);
            this.cardController.setCurrentCardState(this);
        }
        super.setVisible(flag);
    }

    public CardBase(CardController cardController) {
        this.setLayout(new BoxLayout(this, 3));
        this.cardController = cardController;
        this.setOpaque(false);
    }
}

