/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.InstallerModel;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.io.InputStream;

public class RamdiskLoadingStage
extends BaseStage
implements IInstallerStage {
    private InstallerModel model;
    private INovacomDevice device;
    private IStageProgressReporter progress;
    private Object progressId;
    private int percent = 0;
    private static final int GET_RAMDISK = 20;
    private static final int UPLOAD_RAMDISK = 30;

    public RamdiskLoadingStage(InstallerModel model, INovacomDevice device) {
        this.model = model;
        this.device = device;
    }

    public String toString() {
        return "Ramdisk Loader";
    }

    private void updateProgress(int add) {
        this.percent += add;
        this.progress.updateJob(this.progressId, this.percent);
    }

    public void run() throws IOException, NovacomException {
        String filename = this.model.getRamDiskFilename();
        INovacomStream stream = this.device.putInMemory("", true);
        InputStream inputStream = this.model.getRamDiskFileStream();
        byte[] data = new byte[65536];
        long count = this.model.getFileSize(filename);
        this.progress = this.getProgressHandler();
        System.out.println("fileSize " + count);
        this.progressId = this.progress.startJob("Loading Ramdisk", (int)(count / (long)data.length) + 1);
        this.progress.commentOnJob(this.progressId, "count is" + count);
        this.updateProgress(20);
        while (count > 0L) {
            int rc = inputStream.read(data);
            stream.write(data, 0, rc);
            this.progress.commentOnJob(this.progressId, "leftToWrite " + count);
            System.out.println("leftToWrite " + (count -= (long)rc));
        }
        this.progress.commentOnJob(this.progressId, "Booting");
        inputStream.close();
        stream.closeOutput();
        stream.close();
        this.updateProgress(30);
        this.progress.commentOnJob(this.progressId, "Waiting for device to come back");
        this.device.waitForDeviceToAppear();
        this.progress.commentOnJob(this.progressId, "Ramdisk has booted!");
        this.progress.endJob(this.progressId);
    }
}

