/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.BootieUtilities;
import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.nova.installer.core.stages.GoIntoUpdateModeStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class ChargeBatteryStage
extends BaseStage
implements IInstallerStage {
    private static final Integer REQUIRED_POWER_PERCENTAGE = 25;
    private static final Integer RECHARGE_RETRY_COUNT = 5;
    private final INovacomDevice device;
    private Object jobId = null;
    private IStageProgressReporter progress = null;
    private int currentChargeLevel = 0;

    public ChargeBatteryStage(INovacomDevice device) {
        this.device = device;
    }

    public String toString() {
        return "Battery Charger";
    }

    private void chargeBattery() throws NovacomException, IOException {
        INovacomStream stream = this.device.runProgram("", null);
        String command = "charging enable " + REQUIRED_POWER_PERCENTAGE;
        byte[] bytes = command.getBytes("US-ASCII");
        stream.write(bytes);
        stream.closeOutput();
        String streamReturn = stream.readLine();
        while (true) {
            streamReturn = null;
            streamReturn = stream.readLine();
            if (streamReturn == null) {
                this.progress.commentOnJob(this.jobId, "stream interupted");
                throw new NovacomException(-1, "stream interupted");
            }
            while (!streamReturn.startsWith("sys_check_low_battery") && !streamReturn.startsWith("p=") && streamReturn.length() != 0) {
                streamReturn = stream.readLine();
                this.progress.commentOnJob(this.jobId, "+++++" + streamReturn + "-----");
            }
            if (streamReturn.length() == 0) break;
            if (streamReturn.length() > 0) {
                int end;
                int start = streamReturn.indexOf("p=") + 2;
                String strReadBatteryPercentage = streamReturn.substring(start, end = streamReturn.indexOf(" ", start));
                int readBatteryPercentage = new Integer(strReadBatteryPercentage);
                if (readBatteryPercentage > this.currentChargeLevel) {
                    this.currentChargeLevel = readBatteryPercentage;
                    this.progress.updateJob(this.jobId, this.currentChargeLevel);
                    this.progress.commentOnJob(this.jobId, "battery percentage changed");
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            stream.flush();
        }
        this.progress.commentOnJob(this.jobId, "power charged up");
        stream.close();
    }

    public void run() throws NovacomException, IOException {
        this.progress = this.getProgressHandler();
        this.jobId = this.progress.startJob("Battery Charger Stage", 100);
        if (this.device.getState() != Novacom.DeviceState.BOOTLOADER) {
            GoIntoUpdateModeStage intoUpdateMode = new GoIntoUpdateModeStage(this.device);
            intoUpdateMode.run();
        }
        BootieUtilities bootie = new BootieUtilities(this.device);
        int currentPercentage = bootie.checkPowerStatus();
        if (REQUIRED_POWER_PERCENTAGE > currentPercentage) {
            this.progress.commentOnJob(this.jobId, "Battery at " + currentPercentage + "%");
            int count = 0;
            do {
                this.progress.commentOnJob(this.jobId, "Battery Charging Started");
                this.progress.commentOnJob(this.jobId, "Charging to Sufficient Power (" + REQUIRED_POWER_PERCENTAGE + "%), this may take a couple of minutes");
                this.chargeBattery();
                if (++count <= RECHARGE_RETRY_COUNT) continue;
                throw new NovacomException(-1, "failed to charge batttery");
            } while (REQUIRED_POWER_PERCENTAGE > this.currentChargeLevel);
        }
        this.progress.endJob(this.jobId);
    }
}

