/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.MountUtils;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class SuperToolUtilities {
    private final INovacomDevice device;

    public SuperToolUtilities(INovacomDevice device) throws IOException, NovacomException {
        this.device = device;
    }

    private void wipe(MountUtils.MountParts partition) throws NovacomException, IOException {
        INovacomStream cmdOut = null;
        String logPartition = partition.getPartition(true);
        String args = "if=/dev/zero of=" + logPartition + " bs=65536";
        System.out.println("/bin/dd " + args);
        cmdOut = this.device.runProgram("/bin/dd", new String[]{args});
        System.out.println(cmdOut.readLine());
    }

    public void secureWipe() throws NovacomException, IOException {
        Novacom.DeviceState deviceState = this.device.getState();
        if (deviceState == Novacom.DeviceState.INSTALLER) {
            MountUtils mUtil = new MountUtils(this.device);
            System.out.println(mUtil.toString());
            this.wipe(MountUtils.MountParts.LOGFS);
            this.wipe(MountUtils.MountParts.VARFS);
            this.wipe(MountUtils.MountParts.MEDIAFS);
        } else {
            System.out.println("secureWipe not excuted:  not in installer mode");
        }
    }

    public int getOpticalSliderCount() throws NovacomException, IOException {
        Novacom.DeviceState deviceState = this.device.getState();
        if (deviceState == Novacom.DeviceState.OS) {
            INovacomStream lunaSendOut = this.device.runProgram("/usr/bin/luna-send", new String[]{"-n 1 palm://com.palm.hidd/HidKeypad/OpticalCount {\"mode\":\"get\"}"});
            String line = lunaSendOut.readLine();
            System.out.println(line);
            int lengthOfHeader = 73;
            if (line.length() <= 76) {
                throw new NovacomException(-1, "optical slider count coudln't be read:" + line);
            }
            line = line.substring(lengthOfHeader);
            return new Integer(line.replaceAll("\\D", ""));
        }
        return 0;
    }

    public int getHallSliderCount() throws NovacomException, IOException {
        Novacom.DeviceState deviceState = this.device.getState();
        if (deviceState == Novacom.DeviceState.OS) {
            INovacomStream lunaSendOut = this.device.runProgram("/usr/bin/luna-send", new String[]{"-n 1 palm://com.palm.hidd/HidKeypad/HallCount {\"mode\":\"get\"}"});
            String line = lunaSendOut.readLine();
            System.out.println(line);
            System.out.println(line);
            int lengthOfHeader = 73;
            if (line.length() <= 76) {
                throw new NovacomException(-1, "hall slider count coudln't be read:" + line);
            }
            line = line.substring(lengthOfHeader);
            return new Integer(line.replaceAll("\\D", ""));
        }
        return 0;
    }
}

