/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.LoggerUtils;
import com.palm.nova.installer.core.NullProgressReporter;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseStage
implements IInstallerStage {
    protected IStageProgressReporter progress;
    protected final INovacomDevice device;
    protected Object jobId = null;

    protected BaseStage(INovacomDevice device) {
        this.device = device;
    }

    public void setProgressHandler(IStageProgressReporter progress) {
        this.progress = progress;
    }

    public IStageProgressReporter getProgressHandler() {
        if (this.progress != null) {
            return this.progress;
        }
        return new NullProgressReporter();
    }

    protected void runCommand(String command, String[] args) throws IOException, NovacomException {
        if (args == null) {
            args = new String[]{};
        }
        INovacomStream stream = this.device.runProgram(command, args);
        stream.flush();
        this.printStreamToProgressReporter(stream, true);
    }

    protected void printStreamToProgressReporter(INovacomStream stream) throws IOException, NovacomException {
        this.printStreamToProgressReporter(stream, true);
    }

    protected void printStreamToProgressReporter(INovacomStream stream, Boolean closeStream) throws IOException, NovacomException {
        String line = stream.readLine();
        while (line.compareTo("") != 0) {
            this.getProgressHandler().commentOnJob(this.jobId, line);
            line = stream.readLine();
        }
        if (closeStream.booleanValue()) {
            stream.flush();
            stream.close();
        }
    }

    @Override
    public abstract String toString();

    @Override
    public abstract void run() throws IOException, NovacomException;

    protected class StreamReaderThread
    extends Thread {
        INovacomStream stream;
        Object jobId;
        boolean stringFoundInJobOutput;
        String checkForThisStringInOutput;

        public StreamReaderThread(INovacomStream stream, Object jobId) {
            this(stream, jobId, null);
        }

        public StreamReaderThread(INovacomStream stream, Object jobId, String checkForThisStringInOutput) {
            this.stream = stream;
            this.jobId = jobId;
            this.stringFoundInJobOutput = false;
            this.checkForThisStringInOutput = checkForThisStringInOutput;
        }

        @Override
        public void run() {
            Logger logger = LoggerUtils.getInstance().getLogger("StreamReaderThread");
            try {
                String line;
                while ((line = this.stream.readLine()).compareTo("") != 0) {
                    if (null != this.checkForThisStringInOutput && -1 != line.indexOf(this.checkForThisStringInOutput)) {
                        this.stringFoundInJobOutput = true;
                    }
                    BaseStage.this.progress.commentOnJob(this.jobId, line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(Level.WARNING, "", e);
            }
        }

        boolean didWeFindTheStringWeWereLookingFor() {
            return this.stringFoundInJobOutput;
        }
    }
}

