/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.MountUtils;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class AppFolderDeletionStage
extends BaseStage {
    private static final String RUNNER_NAME = "AppDeletion";
    private static final String RM = "/bin/rm";
    private static final String MKDIR = "/bin/mkdir";
    private static final String TEMP_MEDIAFS = "/tmp_mediafs";
    private static final String APP_DIR = "/.palm";

    public AppFolderDeletionStage(INovacomDevice device) {
        super(device);
    }

    @Override
    public void run() throws IOException, NovacomException {
        MountUtils mountUtils;
        IStageProgressReporter reporter = this.getProgressHandler();
        this.jobId = reporter.startJob(RUNNER_NAME, 100);
        reporter.commentOnJob(this.jobId, "deleting applications folder ");
        this.runCommand(RM, new String[]{"-rf", TEMP_MEDIAFS});
        this.runCommand(MKDIR, new String[]{"-p", TEMP_MEDIAFS});
        try {
            mountUtils = new MountUtils(this.device);
            mountUtils.mount(MountUtils.MountParts.MEDIAFS, MountUtils.FsType.VFAT, TEMP_MEDIAFS);
        }
        catch (NovacomException e) {
            reporter.commentOnJob(this.jobId, "No media partition; nothing to do");
            reporter.endJob(this.jobId);
            return;
        }
        String appDirectory = "/tmp_mediafs/.palm";
        reporter.commentOnJob(this.jobId, "attempting to remove appDirectory: " + appDirectory);
        this.runCommand(RM, new String[]{"-r", appDirectory});
        reporter.commentOnJob(this.jobId, "removed the appDirectory: " + appDirectory);
        mountUtils.umount(MountUtils.MountParts.MEDIAFS);
        reporter.endJob(this.jobId);
    }

    @Override
    public String toString() {
        return RUNNER_NAME;
    }
}

