/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.LoggerUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FlashOptions
extends Properties {
    private static final long serialVersionUID = 3832259035964480295L;
    public String host = null;
    public String image = null;
    public String customization = null;
    public String component = null;
    public String imageType = "cust";
    public String custType = null;
    public String softwareUpdateSite = null;
    public String massStorage = null;
    public String devMode = null;
    public String postFlashScript = null;
    public String deviceId = null;
    public int rev = 0;
    public boolean verifyRom = true;
    public boolean saveMsm = true;
    public boolean skipBatteryCheck = false;
    public boolean skipFirstUse = false;
    public SkipCheck modemUpdate = SkipCheck.CHECK;
    public SkipCheck firmwareUpdate = SkipCheck.CHECK;
    public SkipCheck touchpanelUpdate = SkipCheck.CHECK;
    public SkipCheck a6Update = SkipCheck.CHECK;
    public int rootfsMargin = 0;
    protected static Logger logger = LoggerUtils.getInstance().getLogger("NDI.Config");
    protected static final String dirName = System.getProperty("os.name").toLowerCase().contains("windows") ? "ndi" : ".ndi";

    public FlashOptions() {
    }

    public FlashOptions(InputStream fis) {
        try {
            this.readConfigFile(fis);
        }
        catch (IOException e) {
            logger.severe("Unable to read config file");
        }
    }

    public FlashOptions(File configFile) {
        this.readConfigFile(configFile);
    }

    public void newLogger() {
        logger = LoggerUtils.getInstance().getLogger("NDI.Config");
    }

    public void setModemUpdate(String s) {
        this.modemUpdate = FlashOptions.parseSkipCheck(s, this.modemUpdate);
    }

    public void setFirmwareUpdate(String s) {
        this.firmwareUpdate = FlashOptions.parseSkipCheck(s, this.firmwareUpdate);
    }

    public void setTouchpanelUpdate(String s) {
        this.touchpanelUpdate = FlashOptions.parseSkipCheck(s, this.touchpanelUpdate);
    }

    public void setA6Update(String s) {
        this.a6Update = FlashOptions.parseSkipCheck(s, this.a6Update);
    }

    public void doForceModemUpdate(boolean doForceModemUpdate) {
        if (doForceModemUpdate) {
            this.modemUpdate = SkipCheck.FORCE;
        } else if (this.modemUpdate == SkipCheck.FORCE) {
            this.modemUpdate = SkipCheck.CHECK;
        }
    }

    public void doSkipModemUpdate(boolean doSkipModemUpdate) {
        if (doSkipModemUpdate) {
            this.modemUpdate = SkipCheck.SKIP;
        } else if (this.modemUpdate == SkipCheck.SKIP) {
            this.modemUpdate = SkipCheck.CHECK;
        }
    }

    public void doForceFirmwareUpdate(boolean doForceFirmwareUpdate) {
        if (doForceFirmwareUpdate) {
            this.firmwareUpdate = SkipCheck.FORCE;
        } else if (this.firmwareUpdate == SkipCheck.FORCE) {
            this.firmwareUpdate = SkipCheck.CHECK;
        }
    }

    public void doSkipFirmwareUpdate(boolean doSkipFirmwareUpdate) {
        if (doSkipFirmwareUpdate) {
            this.firmwareUpdate = SkipCheck.SKIP;
        } else if (this.firmwareUpdate == SkipCheck.SKIP) {
            this.firmwareUpdate = SkipCheck.CHECK;
        }
    }

    public void doForceA6Update(boolean doForceA6Update) {
        if (doForceA6Update) {
            this.a6Update = SkipCheck.FORCE;
        } else if (this.a6Update == SkipCheck.FORCE) {
            this.a6Update = SkipCheck.CHECK;
        }
    }

    public void doSkipA6Update(boolean doSkipA6Update) {
        if (doSkipA6Update) {
            this.a6Update = SkipCheck.SKIP;
        } else if (this.a6Update == SkipCheck.SKIP) {
            this.a6Update = SkipCheck.CHECK;
        }
    }

    public void doForceTouchpanelUpdate(boolean doForceTouchpanelUpdate) {
        if (doForceTouchpanelUpdate) {
            this.touchpanelUpdate = SkipCheck.FORCE;
        } else if (this.touchpanelUpdate == SkipCheck.FORCE) {
            this.touchpanelUpdate = SkipCheck.CHECK;
        }
    }

    public void doSkipTouchpanelUpdate(boolean doSkipTouchpanelUpdate) {
        if (doSkipTouchpanelUpdate) {
            this.touchpanelUpdate = SkipCheck.SKIP;
        } else if (this.touchpanelUpdate == SkipCheck.SKIP) {
            this.touchpanelUpdate = SkipCheck.CHECK;
        }
    }

    public static File ndiConfigDir() {
        String home = System.getProperty("user.home");
        File configDir = new File(home, dirName);
        if (!configDir.exists()) {
            if (!configDir.mkdirs()) {
                logger.warning("Unable to create config dir " + configDir);
                return null;
            }
        } else if (!configDir.isDirectory()) {
            logger.warning("Config dir exists, but is not a directory:" + configDir);
            return null;
        }
        return configDir;
    }

    public static long getMotdStamp() {
        try {
            File configDir = FlashOptions.ndiConfigDir();
            if (configDir == null) {
                return 0L;
            }
            File motd = new File(configDir, "motd");
            return motd.lastModified();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static void setMotdStamp() {
        try {
            File motd;
            File configDir = FlashOptions.ndiConfigDir();
            if (configDir == null || (motd = new File(configDir, "motd")) == null || !motd.createNewFile() && !motd.setLastModified(System.currentTimeMillis())) {
                logger.warning("Unable to set motd timestamp");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dumpVars(Level lvl) {
        if (this.host != null) {
            logger.log(lvl, "host=" + this.host);
        }
        if (this.deviceId != null) {
            logger.log(lvl, "nduid=" + this.deviceId);
        }
        if (this.image != null) {
            logger.log(lvl, "image=" + this.image);
        }
        if (this.customization != null) {
            logger.log(lvl, "custom=" + this.customization);
        }
        if (this.component != null) {
            logger.log(lvl, "component=" + this.component);
        }
        if (this.imageType != null) {
            logger.log(lvl, "type=" + this.imageType);
        }
        if (this.custType != null) {
            logger.log(lvl, "cust=" + this.custType);
        }
        if (this.rev != 0) {
            logger.log(lvl, "rev=" + this.rev);
        }
        if (this.massStorage != null) {
            logger.log(lvl, "massstorage=" + this.massStorage);
        }
        if (this.devMode != null) {
            logger.log(lvl, "devmode=" + this.devMode);
        }
        if (this.postFlashScript != null) {
            logger.log(lvl, "postFlashScript=" + this.postFlashScript);
        }
        logger.log(lvl, "skipbatterycheck=" + this.skipBatteryCheck);
        logger.log(lvl, "modemupdate=" + (Object)((Object)this.modemUpdate));
        logger.log(lvl, "firmwareupdate=" + (Object)((Object)this.firmwareUpdate));
        logger.log(lvl, "touchpanelupdate=" + (Object)((Object)this.touchpanelUpdate));
        logger.log(lvl, "a6update=" + (Object)((Object)this.a6Update));
        logger.log(lvl, "savemsm=" + this.saveMsm);
        logger.log(lvl, "verifyrom=" + this.verifyRom);
        logger.log(lvl, "skipfirstuse=" + this.skipFirstUse);
        logger.log(lvl, "rootfsmargin=" + this.rootfsMargin);
        if (this.softwareUpdateSite != null) {
            logger.log(lvl, "softwareupdate=" + this.softwareUpdateSite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readConfigFile(File configFile) {
        if (!configFile.isFile() && configFile.toString().indexOf(File.separator) == -1) {
            configFile = new File(FlashOptions.ndiConfigDir(), configFile.toString());
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(configFile);
            boolean bl = this.readConfigFile(fis);
            return bl;
        }
        catch (FileNotFoundException e) {
            logger.severe("Config file " + configFile + " not found");
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.severe("Unable to read config file " + configFile);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
            }
            catch (IOException e) {}
        }
    }

    public boolean readConfigFile(InputStream is) throws IOException {
        BufferedInputStream fis = null;
        fis = new BufferedInputStream(is);
        this.load(fis);
        this.host = this.propString("host", this.host);
        this.image = this.propString("image", this.image);
        this.customization = this.propString("custom", this.customization);
        this.component = this.propString("component", this.component);
        this.imageType = this.propString("type", this.imageType);
        this.custType = this.propString("cust", this.custType);
        this.rev = this.propInt("rev", this.rev);
        this.softwareUpdateSite = this.propString("softwareupdate", this.softwareUpdateSite);
        this.massStorage = this.propString("massstorage", this.massStorage);
        this.devMode = this.propString("devmode", this.devMode);
        this.postFlashScript = this.propString("postflash", this.postFlashScript);
        this.deviceId = this.propString("nduid", this.deviceId);
        this.saveMsm = this.propBool("savemsm", this.saveMsm);
        this.rootfsMargin = this.propInt("rootfsmargin", this.rootfsMargin);
        this.verifyRom = this.propBool("verifyrom", this.verifyRom);
        this.skipFirstUse = this.propBool("skipfirstuse", this.skipFirstUse);
        this.skipBatteryCheck = this.propBool("skipbatterycheck", this.skipBatteryCheck);
        this.modemUpdate = this.propSkipCheck("modemupdate", this.modemUpdate);
        this.firmwareUpdate = this.propSkipCheck("firmwareupdate", this.firmwareUpdate);
        this.touchpanelUpdate = this.propSkipCheck("touchpanelupdate", this.touchpanelUpdate);
        this.a6Update = this.propSkipCheck("a6update", this.a6Update);
        return true;
    }

    public void writeConfigFile(File configFile) {
        try {
            PrintWriter ofile = new PrintWriter(configFile);
            this.writeConfigFile(ofile);
            ofile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.severe("Failed to write file " + configFile + ": " + e);
        }
    }

    public void writeConfigFile(PrintWriter ofile) {
        if (this.host != null && this.host.length() > 0) {
            ofile.println("host=" + this.host);
        }
        if (this.component != null && this.component.length() > 0) {
            ofile.println("component=" + this.component);
        }
        if (this.imageType != null && this.imageType.length() > 0) {
            ofile.println("type=" + this.imageType);
        }
        if (this.custType != null && this.custType.length() > 0) {
            ofile.println("cust=" + this.custType);
        }
        if (this.rev != 0) {
            ofile.println("rev=" + this.rev);
        }
        if (this.image != null && this.image.length() > 0) {
            ofile.println("image=" + this.image);
        }
        if (this.customization != null && this.customization.length() > 0) {
            ofile.println("custom=" + this.customization);
        }
        ofile.println("a6update=" + (Object)((Object)this.a6Update));
        if (this.devMode != null && this.devMode.length() > 0) {
            ofile.println("devmode=" + this.devMode);
        }
        ofile.println("firmwareupdate=" + (Object)((Object)this.firmwareUpdate));
        if (this.massStorage != null && this.massStorage.length() > 0) {
            ofile.println("massstorage=" + this.massStorage);
        }
        ofile.println("modemupdate=" + (Object)((Object)this.modemUpdate));
        if (this.postFlashScript != null && this.postFlashScript.length() > 0) {
            ofile.println("postflash=" + this.postFlashScript);
        }
        if (this.rootfsMargin != 0) {
            ofile.println("rootfsmargin=" + this.rootfsMargin);
        }
        ofile.println("savemsm=" + this.saveMsm);
        ofile.println("skipbatterycheck=" + this.skipBatteryCheck);
        ofile.println("skipfirstuse=" + this.skipFirstUse);
        if (this.softwareUpdateSite != null && this.softwareUpdateSite.length() > 0) {
            ofile.println("softwareupdate=" + this.softwareUpdateSite);
        }
        ofile.println("touchpanelupdate=" + (Object)((Object)this.touchpanelUpdate));
        ofile.println("verifyrom=" + this.verifyRom);
    }

    public final String propString(String name, String def) {
        String value = this.getProperty(name);
        return value != null ? value : def;
    }

    public final boolean propBool(String name, boolean def) {
        String value = this.getProperty(name);
        return value != null ? Boolean.valueOf(value) : def;
    }

    public final int propInt(String name, int def) {
        String value = this.getProperty(name);
        return value != null ? Integer.parseInt(value) : def;
    }

    public final SkipCheck propSkipCheck(String name, SkipCheck dflt) {
        String value = this.getProperty(name);
        if (value == null) {
            return dflt;
        }
        SkipCheck rval = FlashOptions.parseSkipCheck(value, null);
        if (rval == null) {
            logger.warning("Property " + name + " value " + value + " not recognized");
            return dflt;
        }
        return rval;
    }

    private static final SkipCheck parseSkipCheck(String value, SkipCheck dflt) {
        if (value == null) {
            return dflt;
        }
        if (value.toLowerCase().contains("skip")) {
            return SkipCheck.SKIP;
        }
        if (value.toLowerCase().contains("check")) {
            return SkipCheck.CHECK;
        }
        if (value.toLowerCase().contains("force")) {
            return SkipCheck.FORCE;
        }
        return dflt;
    }

    public static enum SkipCheck {
        SKIP,
        CHECK,
        FORCE;

    }
}

