/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.LoggerUtils;
import com.palm.nova.installer.core.TrenchcoatModel;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;

public class TrenchcoatStage
extends BaseStage
implements IInstallerStage {
    public static final String TRENCHCOAT_PATH = "/sbin/trenchcoat";
    public static final String TRENCHCOAT_POSTFLASH_PATH = "/sbin/tcpostflash.sh";
    public static final String DATE_PATH = "/bin/date";
    private final TrenchcoatModel model;

    public TrenchcoatStage(TrenchcoatModel model, INovacomDevice device) {
        super(device);
        this.model = model;
    }

    @Override
    public String toString() {
        return "Trenchcoat";
    }

    @Override
    public void run() throws IOException, NovacomException {
        this.progress = this.getProgressHandler();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMddHHmmyyyy");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Calendar now = Calendar.getInstance();
        StringBuffer tzScript = new StringBuffer("#!/bin/sh\n/bin/echo 'TZ=GMT' >> /etc/profile");
        tzScript.append("\nexit 0\n");
        INovacomStream stream = this.device.runScript(tzScript.toString(), "/tmp/settz.sh");
        stream.waitForReturnCode();
        stream.close();
        stream = this.device.runProgram(DATE_PATH, new String[]{dateFormat.format(now.getTime())});
        stream.waitForReturnCode();
        stream.close();
        this.jobId = this.progress.startJob("Trenchcoat", 100);
        this.progress.commentOnJob(this.jobId, "Starting /sbin/trenchcoat");
        stream = this.device.runProgram(TRENCHCOAT_PATH, null);
        TrenchcoatReaderThread thread = new TrenchcoatReaderThread(stream, this.jobId);
        thread.start();
        thread.setPriority(10);
        this.progress.commentOnJob(this.jobId, "Starting Stream Reader");
        try {
            StringBuffer buffer = new StringBuffer(this.model.toXMLString());
            buffer.append("\n");
            System.out.print(buffer.toString());
            stream.write(buffer.toString().getBytes("US-ASCII"));
            stream.flush();
            this.progress.commentOnJob(this.jobId, "Wrote XML Configuration Data");
            String[] filenames = this.model.getFilesInOrder();
            for (int i = 0; i < filenames.length; ++i) {
                this.progress.commentOnJob(this.jobId, "Sending File: " + filenames[i]);
                long count = stream.write(this.model.getInstallerModel().getInputStream(filenames[i]));
                this.progress.commentOnJob(this.jobId, "Sent " + count + " bytes");
            }
        }
        catch (TransformerException e) {
            IOException e2 = new IOException("Unable to transform model back to XML: " + e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
        catch (SocketException e) {
            throw new TrenchcoatException(-1, 100, thread.errorMessage());
        }
        try {
            this.progress.commentOnJob(this.jobId, "Waiting....");
            thread.join();
            this.progress.commentOnJob(this.jobId, "Finished!");
        }
        catch (InterruptedException e) {
            throw new IOException("Reader thread never completed.");
        }
        int trenchcoatReturn = stream.waitForReturnCode();
        stream.close();
        StringBuffer script = new StringBuffer("#!/bin/sh\n/bin/cat /proc/mounts | /bin/grep tcmnt | /usr/bin/awk '{print $2}' > /tmp/mtpts.txt\n");
        script.append("nummounts=`/usr/bin/wc -l /tmp/mtpts.txt | /usr/bin/awk '{print $1}`\n");
        script.append("if [ $nummounts -gt 0 ]\n");
        script.append("then\n");
        script.append("for mtpt in `/bin/cat /tmp/mtpts.txt`\n");
        script.append("do\n");
        script.append("/usr/bin/fuser -k $mtpt\n");
        script.append("/bin/umount $mtpt\n");
        script.append("done\n");
        script.append("/usr/sbin/lvm.static vgchange -an\n");
        script.append("exit 1\n");
        script.append("else\n");
        script.append("exit 0\n");
        script.append("fi\n");
        stream = this.device.putFile("/tmp/ckmounts.sh");
        stream.write(script.toString().getBytes("US-ASCII"));
        stream.closeInput();
        stream.closeOutput();
        stream.waitForReturnCode();
        stream.close();
        stream = this.device.runProgram("/bin/sh", new String[]{"-c /tmp/ckmounts.sh"});
        int mountReturn = stream.waitForReturnCode();
        stream.close();
        if (trenchcoatReturn != 0) {
            throw new NovacomException(trenchcoatReturn, 100 + trenchcoatReturn, "Trenchcoat returned failure error code " + trenchcoatReturn);
        }
        if (mountReturn != 0) {
            throw new NovacomException(mountReturn, 41, "Trenchcoat failed to unmount all partitions, error code " + mountReturn);
        }
        this.progress.endJob(this.jobId);
    }

    protected class TrenchcoatReaderThread
    extends BaseStage.StreamReaderThread {
        String fatal;
        String error;

        public TrenchcoatReaderThread(INovacomStream stream, Object jobId) {
            super(stream, jobId, null);
            this.fatal = null;
            this.error = null;
        }

        @Override
        public void run() {
            Logger logger = LoggerUtils.getInstance().getLogger("StreamReaderThread");
            try {
                String line;
                while ((line = this.stream.readLine()).compareTo("") != 0) {
                    if (line.contains("<FATAL>")) {
                        this.fatal = line.trim();
                    } else if (line.contains("<ERROR>")) {
                        this.error = line.trim();
                    }
                    TrenchcoatStage.this.progress.commentOnJob(this.jobId, line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(Level.WARNING, "", e);
            }
        }

        String errorMessage() {
            if (this.fatal != null) {
                return this.fatal;
            }
            if (this.error != null) {
                return this.error;
            }
            return "Unknown trenchcoat error";
        }
    }

    public class TrenchcoatException
    extends NovacomException {
        private static final long serialVersionUID = 1L;

        public TrenchcoatException(int errorCode, int exitCode, String errorMsg) {
            super(errorCode, exitCode, errorMsg);
        }

        @Override
        public String toString() {
            return "Trenchcoat error: " + this.getErrorMessage();
        }
    }
}

