/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.FlashOptions;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.MountUtils;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class SaveFlashInfoStage
extends BaseStage {
    private static final String RUNNER_NAME = "SaveFlashInfo";
    private static final String RM = "/bin/rm";
    private static final String MKDIR = "/bin/mkdir";
    private static final String TEMP_ROOT = "/tmp_rootfs";
    private final FlashOptions config;
    private final File logfile;

    public SaveFlashInfoStage(INovacomDevice device, FlashOptions config, File logfile) {
        super(device);
        this.config = config;
        this.logfile = logfile;
    }

    @Override
    public void run() throws IOException, NovacomException {
        IStageProgressReporter reporter = this.getProgressHandler();
        this.jobId = reporter.startJob(RUNNER_NAME, 100);
        reporter.commentOnJob(this.jobId, "Write flash configuration info");
        this.runCommand(RM, new String[]{"-rf", TEMP_ROOT});
        this.runCommand(MKDIR, new String[]{"-p", TEMP_ROOT});
        MountUtils mountUtils = new MountUtils(this.device);
        mountUtils.mount(MountUtils.MountParts.ROOTFS, MountUtils.FsType.EXT3, TEMP_ROOT);
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        this.config.writeConfigFile(pw);
        pw.close();
        INovacomStream stream = this.device.putFile("/tmp_rootfs/etc/palm-install-info");
        stream.write(stringWriter.toString().getBytes());
        stream.close();
        reporter.updateJob(this.jobId, 50);
        if (this.logfile != null) {
            reporter.commentOnJob(this.jobId, "Write install log");
            try {
                stream = this.device.putFile("/tmp_rootfs/etc/palm-install-log");
                stream.write(this.logfile);
                stream.close();
            }
            catch (IOException e) {
                reporter.commentOnJob(this.jobId, "Install log write failed: " + e);
            }
        }
        reporter.updateJob(this.jobId, 100);
        mountUtils.umount(MountUtils.MountParts.ROOTFS);
        reporter.endJob(this.jobId);
    }

    @Override
    public String toString() {
        return RUNNER_NAME;
    }
}

