/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.InstallerModel;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.io.InputStream;

public class RamdiskLoadingStage
extends BaseStage
implements IInstallerStage {
    private InstallerModel model;
    private int percent = 0;
    private static final int GET_RAMDISK = 20;
    private static final int UPLOAD_RAMDISK = 30;

    public RamdiskLoadingStage(InstallerModel model, INovacomDevice device) {
        super(device);
        this.model = model;
    }

    @Override
    public String toString() {
        return "Ramdisk Loader";
    }

    private void updateProgress(int add) {
        this.percent += add;
        this.progress.updateJob(this.jobId, this.percent);
    }

    @Override
    public void run() throws IOException, NovacomException {
        int rc;
        long count;
        String filename = this.model.getRamDiskFilename();
        INovacomStream stream = this.device.putInMemory("", true);
        InputStream inputStream = this.model.getRamDiskFileStream();
        byte[] data = new byte[65536];
        this.progress = this.getProgressHandler();
        this.jobId = this.progress.startJob("Loading Ramdisk", (int)(count / (long)data.length) + 1);
        this.progress.commentOnJob(this.jobId, "count is " + count);
        this.updateProgress(20);
        long size = count;
        long pct = -1L;
        for (count = this.model.getFileSize(filename); count > 0L; count -= (long)rc) {
            rc = inputStream.read(data);
            stream.write(data, 0, rc);
            long p = count * 50L / size;
            if (p == pct) continue;
            this.progress.commentOnJob(this.jobId, "leftToWrite " + count);
            pct = p;
        }
        this.progress.commentOnJob(this.jobId, "Booting");
        inputStream.close();
        stream.closeOutput();
        stream.close();
        this.updateProgress(30);
        this.progress.commentOnJob(this.jobId, "Waiting for device to come back");
        this.device.waitForDeviceToAppear();
        this.progress.commentOnJob(this.jobId, "Ramdisk has booted!");
        this.progress.endJob(this.jobId);
    }
}

