/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class A6UpdateStage
extends BaseStage
implements IInstallerStage {
    private static final String UPDATE_CMD = "/usr/bin/PmA6Updater";
    private static final String UPDATE_FILE = "/lib/firmware/a6_firmware.txt";
    private static final String RUNNER_NAME = "A6 Updater";
    private boolean forceUpdate = false;

    public A6UpdateStage(INovacomDevice device) {
        super(device);
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    @Override
    public String toString() {
        return RUNNER_NAME;
    }

    @Override
    public void run() throws IOException, NovacomException {
        this.progress = this.getProgressHandler();
        this.jobId = this.progress.startJob(RUNNER_NAME, 100);
        String machineType = this.device.getDeviceInfo().getMachineName();
        if (machineType.contentEquals("castle") || machineType.contentEquals("pixie") || machineType.contentEquals("roadrunner")) {
            this.progress.commentOnJob(this.jobId, "Not updating A6 firmware: no A6 on the device");
            this.progress.endJob(this.jobId);
            return;
        }
        if (!this.device.checkFile(UPDATE_CMD)) {
            this.progress.commentOnJob(this.jobId, "No A6 update for this device");
            this.progress.endJob(this.jobId);
            return;
        }
        this.progress.commentOnJob(this.jobId, "Starting the A6 stage");
        String[] argsOpt = new String[]{"-a"};
        String[] argsForce = new String[]{"-a", "-f"};
        String[] args = argsOpt;
        if (this.forceUpdate) {
            this.progress.commentOnJob(this.jobId, "Forcing A6 update, no matter the version.");
            args = argsForce;
        }
        if (this.tryUpdate(UPDATE_CMD, args)) {
            this.progress.commentOnJob(this.jobId, "Retry A6 updater with old options");
            this.tryUpdate(UPDATE_CMD, new String[]{UPDATE_FILE});
        }
        this.progress.commentOnJob(this.jobId, "Done with A6 stage");
        this.progress.endJob(this.jobId);
    }

    private final boolean tryUpdate(String path, String[] args) throws NovacomException, IOException {
        boolean badopt = false;
        INovacomStream stream = this.device.runProgram(path, args);
        stream.flush();
        String line = stream.readLine();
        while (line.compareTo("") != 0) {
            this.progress.commentOnJob(this.jobId, line);
            if (line.startsWith("/usr/bin/PmA6Updater: invalid option -- ")) {
                badopt = true;
            }
            line = stream.readLine();
        }
        stream.flush();
        stream.close();
        return badopt;
    }
}

