/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ScreenPainter {
    public static final int SMALL = 0;
    public static final int MEDIUM = 1;
    public static final int LARGE = 2;
    public static final int EXTRA_LARGE = 3;
    public static final String FBDRAW_UTIL = "/usr/bin/fbdraw";
    public static final String FBSET_UTIL = "/usr/sbin/fbset";
    private final INovacomDevice device;
    private Rectangle geometry = null;

    public ScreenPainter(INovacomDevice device) {
        this.device = device;
    }

    public void fillScreen(int r, int g, int b) throws IOException, NovacomException {
        String[] args = new String[]{"-fill", Integer.toString(r & 0xFF), Integer.toString(g & 0xFF), Integer.toString(b & 0xFF), "255", "0", "0", "320", "480"};
        this.device.runProgram(FBDRAW_UTIL, args);
    }

    public void drawImage(int x, int y, String filename) throws IOException, NovacomException {
        BufferedImage bufferedImage = ImageIO.read(new File(filename));
        this.drawImage(x, y, bufferedImage);
    }

    public void drawImage(int x, int y, InputStream stream) throws IOException, NovacomException {
        BufferedImage bufferedImage = ImageIO.read(stream);
        this.drawImage(x, y, bufferedImage);
    }

    public void drawImageCentered(String filename) throws IOException, NovacomException {
        BufferedImage bufferedImage = ImageIO.read(new File(filename));
        this.drawImageCentered(bufferedImage);
    }

    public void drawImageCentered(InputStream stream) throws IOException, NovacomException {
        BufferedImage bufferedImage = ImageIO.read(stream);
        this.drawImageCentered(bufferedImage);
    }

    public void drawImageCentered(BufferedImage image) throws IOException, NovacomException {
        int x = 0;
        int y = 0;
        Rectangle geometry = this.getScreenGeometry();
        if (null == geometry) {
            return;
        }
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (geometry.width > imageWidth) {
            x = (geometry.width - imageWidth) / 2;
        }
        if (geometry.height > imageHeight) {
            y = (geometry.height - imageHeight) / 2;
        }
        this.drawImage(x, y, image);
    }

    public synchronized Rectangle getScreenGeometry() throws NovacomException, IOException {
        if (this.geometry != null) {
            return this.geometry;
        }
        INovacomStream stream = this.device.runProgram(FBSET_UTIL, new String[]{"-s"});
        String line = stream.readLine();
        while (line.length() > 0 && null == this.geometry) {
            if (line.contains("geometry")) {
                String[] geoArray = line.trim().split(" ");
                this.geometry = new Rectangle(0, 0, Integer.parseInt(geoArray[1]), Integer.parseInt(geoArray[2]));
                continue;
            }
            line = stream.readLine();
        }
        stream.close();
        return this.geometry;
    }

    public int getGeneralSize() {
        try {
            Rectangle geometry = this.getScreenGeometry();
            int w = geometry.width;
            int h = geometry.height;
            if (w >= 800 && h >= 800) {
                return 3;
            }
            if (w >= 640 && h >= 640) {
                return 2;
            }
            if (w >= 480 && h >= 480) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void drawImage(int x, int y, BufferedImage image) throws IOException, NovacomException {
        String[] args = new String[]{"-pic", Integer.toString(x), Integer.toString(y), Integer.toString(image.getWidth()), Integer.toString(image.getHeight())};
        int[] pixels = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        byte[] rgba = new byte[pixels.length * 4];
        INovacomStream stream = this.device.runProgram(FBDRAW_UTIL, args);
        for (int i = 0; i < pixels.length; ++i) {
            int idx = i * 4;
            int pixel = pixels[i];
            rgba[idx + 2] = (byte)(pixel & 0xFF);
            rgba[idx + 1] = (byte)((pixel & 0xFF00) >> 8);
            rgba[idx + 0] = (byte)((pixel & 0xFF0000) >> 16);
            rgba[idx + 3] = (byte)((pixel & 0xFF000000) >> 24);
        }
        stream.write(rgba);
        stream.closeOutput();
        stream.waitForReturnCode();
        stream.close();
    }
}

