/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.LoggerUtils;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MountUtils {
    private static final String MKDIR = "/bin/mkdir";
    private static final String LVMCMD = "/usr/sbin/lvm.static";
    private static final String MOUNT = "/bin/mount";
    private static final String UMOUNT = "/bin/umount";
    private static final String MMCPART_ROOTFS = "/dev/mmcblk0p2";
    private static final String MMCPART_VAR = "/dev/mmcblk0p3";
    private static String lvmRootFsPath;
    private static String lvmVarFsPath;
    private static String lvmLogFsPath;
    private static String lvmMediaFsPath;
    private static String bootPartition;
    private boolean isLvm = false;
    private final INovacomDevice device;
    Logger logger;

    public MountUtils(INovacomDevice device) {
        this.device = device;
        this.logger = LoggerUtils.getInstance().getLogger("MountUtils");
        try {
            this.readCurrentLvmValues();
            this.getBootPartition();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "", e);
            this.isLvm = false;
        }
    }

    private void setLvmValues(String lvmGroupName, String lvmRootFsVolumeName, String lvmVarFsVolumeName) {
        this.isLvm = true;
        lvmRootFsPath = "/dev/mapper/" + lvmGroupName + "-" + lvmRootFsVolumeName;
        lvmVarFsPath = "/dev/mapper/" + lvmGroupName + "-" + lvmVarFsVolumeName;
        this.logger.info("LVM Root Path: " + lvmRootFsPath);
        this.logger.info("LVM Var Path: " + lvmVarFsPath);
    }

    private void setLvmAllValues(String lvmGroupName, String lvmRootFsVolumeName, String lvmVarFsVolumeName, String lvmLogFsVolumeName, String lvmMediaFsVolumeName) {
        this.isLvm = true;
        this.setLvmValues(lvmGroupName, lvmRootFsVolumeName, lvmVarFsVolumeName);
        lvmLogFsPath = "/dev/mapper/" + lvmGroupName + "-" + lvmLogFsVolumeName;
        lvmMediaFsPath = "/dev/mapper/" + lvmGroupName + "-" + lvmMediaFsVolumeName;
        this.logger.info("LVM Log Path: " + lvmLogFsPath);
        this.logger.info("LVM Media Path: " + lvmMediaFsPath);
    }

    private void getBootPartition() {
        String results = "unknown";
        int returnCode = -1;
        StringBuffer script = new StringBuffer("#!/bin/sh\n");
        script.append("for dev in /dev/mmcblk*p* /dev/[sh]d*; do\n");
        script.append("  if lbl=`e2label $dev 2>/dev/null`; then\n");
        script.append("    if [ \"$lbl\" = '/boot' ]; then\n");
        script.append("       echo $dev\n");
        script.append("       return 0\n");
        script.append("    fi\n");
        script.append("  fi\n");
        script.append("done\n");
        script.append("echo unknown\n");
        script.append("return -1\n");
        try {
            INovacomStream output = this.device.putFile("/tmp/find_boot.sh");
            output.write(script.toString().getBytes("US-ASCII"));
            output.closeInput();
            output.closeOutput();
            output.waitForReturnCode();
            output.close();
            output = this.device.runProgram("/bin/sh", new String[]{"-c", "/tmp/find_boot.sh"});
            results = output.readLine();
            returnCode = output.waitForReturnCode();
            output.close();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "IO exception when obtaining boot partition", e);
        }
        catch (NovacomException e) {
            this.logger.log(Level.WARNING, "novacom exception when obtaining boot partition", e);
        }
        if (0 != returnCode) {
            bootPartition = "unknown";
            this.logger.log(Level.WARNING, "unable to obtain boot partition with /tmp/find_boot.sh script");
        } else {
            bootPartition = results.trim();
        }
    }

    public void readCurrentLvmValues() throws IOException {
        if (this.device.getState() == Novacom.DeviceState.INSTALLER) {
            this.logger.info("looking for LVM while in installer mode");
            try {
                INovacomStream lvmStatic = this.device.getFile(LVMCMD);
                if (lvmStatic == null) {
                    this.logger.warning("no lvmstatic, not lvm");
                    this.isLvm = false;
                    return;
                }
                this.logger.info("got lvm static, running vgscan");
                this.runCommand(LVMCMD, new String[]{"vgscan --ignorelockingfailure"});
                this.logger.info("vgscan ran, running vgchange");
                INovacomStream stream = this.device.runProgram(LVMCMD, new String[]{"vgchange -ay --ignorelockingfailure"});
                this.logger.fine("returned from vgchange");
                stream.flush();
                String line = stream.readLine();
                String lvmGroupName = null;
                Integer numberOfVolumes = 0;
                while (line.compareTo("") != 0) {
                    this.logger.info("MountUtils: " + line.trim());
                    if (line.contains(" logical volume(s) in volume group ")) {
                        String strNumber = (line = line.trim()).substring(0, line.indexOf(" "));
                        numberOfVolumes = new Integer(strNumber);
                        if (numberOfVolumes == 0) break;
                        int afterFirstQuote = line.indexOf("\"") + 1;
                        int secondQuote = line.indexOf("\"", afterFirstQuote);
                        lvmGroupName = line.substring(afterFirstQuote, secondQuote);
                        this.logger.info("lvmGroupName set to " + lvmGroupName);
                    }
                    line = stream.readLine();
                }
                stream.flush();
                stream.close();
                if (numberOfVolumes == 0 || lvmGroupName == null) {
                    this.isLvm = false;
                    return;
                }
                this.setLvmAllValues(lvmGroupName, "root", "var", "log", "media");
            }
            catch (NovacomException e) {
                this.logger.log(Level.WARNING, "no LVVM", e);
                this.isLvm = false;
                return;
            }
        }
    }

    private String runCommand(String command, String[] args) throws IOException, NovacomException {
        this.logger.entering("MountUtils", "runCommand", command);
        INovacomStream stream = this.device.runProgram(command, args);
        stream.flush();
        String line = stream.readLine();
        StringBuffer returnVal = new StringBuffer();
        while (line.compareTo("") != 0) {
            this.logger.fine("MountUtils:" + line.trim());
            returnVal.append(line);
            line = stream.readLine();
        }
        this.logger.fine("flushing and closing");
        stream.flush();
        stream.close();
        this.logger.exiting("MountUtils", "runCommand", command);
        return returnVal.toString();
    }

    public void mount(MountParts partition, FsType fsTypeToMount, String mountPoint) throws NovacomException, IOException {
        this.mount(partition, fsTypeToMount, mountPoint, false);
    }

    public void mount(MountParts partition, FsType fsTypeToMount, String mountPoint, boolean openReadOnly) throws NovacomException, IOException {
        String fsType = "";
        if (fsTypeToMount == FsType.EXT3) {
            fsType = "ext3";
        } else if (fsTypeToMount == FsType.VFAT) {
            fsType = "vfat";
        } else if (null == fsTypeToMount) {
            throw new NovacomException(-1, 4, "Error Mounting: we don't support null partitions");
        }
        if (null != partition.getPartition(this.isLvm)) {
            this.logger.info("Mounting " + partition.getPartition(this.isLvm) + " to: " + mountPoint);
            this.runCommand(LVMCMD, new String[]{"vgchange", "-ay"});
            this.runCommand(MKDIR, new String[]{"-p", mountPoint});
            String returnValFromMount = openReadOnly ? this.runCommand(MOUNT, new String[]{"-r", "-t", fsType.toString(), partition.getPartition(this.isLvm), mountPoint}) : this.runCommand(MOUNT, new String[]{"-t", fsType.toString(), partition.getPartition(this.isLvm), mountPoint});
            if (returnValFromMount.contains("No such file or directory")) {
                this.logger.severe("failed to mount, returning exception");
                throw new NovacomException(-1, 41, "unable to mount");
            }
        } else {
            this.logger.warning("Couldn't Mount: " + partition.toString());
        }
    }

    public void umountPart(MountParts partition) throws NovacomException, IOException {
        this.logger.info("Unmounting " + partition.getPartition(this.isLvm));
        if (null != partition.getPartition(this.isLvm)) {
            String returnVal = this.runCommand(UMOUNT, new String[]{partition.getPartition(this.isLvm)});
            if (MountUtils.umountFailed(returnVal)) {
                this.logger.warning("MountUtils: unmount failed, retrying in 1 second");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.log(Level.WARNING, "", e);
                    e.printStackTrace();
                }
                returnVal = this.runCommand(UMOUNT, new String[]{partition.getPartition(this.isLvm)});
                if (MountUtils.umountFailed(returnVal)) {
                    this.logger.severe("MountUtils: unmount failed: " + returnVal);
                    throw new NovacomException(-1, 41, "unmount failed");
                }
            }
            this.logger.info("MountUtils: unmount successful");
        } else {
            this.logger.warning("Couldn't Unmount: " + partition.toString());
        }
    }

    public void umount(MountParts partition) throws NovacomException, IOException {
        this.umountPart(partition);
        this.runCommand(LVMCMD, new String[]{"vgchange", "-an"});
    }

    private static final boolean umountFailed(String returnVal) {
        return returnVal != null && (returnVal.contains("cannot umount") || returnVal.contains("can't umount"));
    }

    public void mountAll(String mountPoint) throws NovacomException, IOException {
        this.mount(MountParts.ROOTFS, FsType.EXT3, mountPoint, false);
        this.mount(MountParts.VARFS, FsType.EXT3, mountPoint + "/var", false);
        this.mount(MountParts.LOGFS, FsType.EXT3, mountPoint + "/var/log", false);
        this.mount(MountParts.MEDIAFS, FsType.VFAT, mountPoint + "/media/internal", false);
    }

    public void umountAll() throws NovacomException, IOException {
        this.umountPart(MountParts.MEDIAFS);
        this.umountPart(MountParts.LOGFS);
        this.umountPart(MountParts.VARFS);
        this.umountPart(MountParts.ROOTFS);
        this.runCommand(LVMCMD, new String[]{"vgchange", "-an"});
    }

    public static enum FsType {
        EXT3,
        VFAT;

    }

    public static enum MountParts {
        ROOTFS,
        VARFS,
        BOOTFS,
        LOGFS,
        MEDIAFS;


        String getPartition(boolean isLvm) throws NovacomException {
            switch (this) {
                case ROOTFS: {
                    return isLvm ? lvmRootFsPath : MountUtils.MMCPART_ROOTFS;
                }
                case VARFS: {
                    return isLvm ? lvmVarFsPath : MountUtils.MMCPART_VAR;
                }
                case BOOTFS: {
                    return bootPartition;
                }
                case LOGFS: {
                    return isLvm ? lvmLogFsPath : null;
                }
                case MEDIAFS: {
                    return isLvm ? lvmMediaFsPath : null;
                }
            }
            throw new NovacomException(-1, "Invalid Enum");
        }
    }
}

